/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.acs.container.ComponentAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ComponentMap {
    private LinkedHashMap<Integer, ComponentAdapter> m_map;
    private Logger logger;

    ComponentMap(Logger logger) {
        this.logger = logger;
        this.m_map = new LinkedHashMap();
    }

    synchronized boolean reserveComponent(int compHandle) {
        boolean ret = false;
        Integer handleObj = compHandle;
        if (!this.m_map.containsKey(handleObj) || this.m_map.get(handleObj) != null) {
            this.m_map.put(handleObj, null);
            ret = true;
        }
        return ret;
    }

    synchronized ComponentAdapter put(int compHandle, ComponentAdapter compAdapter) {
        return this.m_map.put(compHandle, compAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sort(int[] sortedHandles) {
        LinkedHashMap<Integer, ComponentAdapter> tmpMap = new LinkedHashMap<Integer, ComponentAdapter>(this.m_map.size());
        try {
            for (int i = 0; i < sortedHandles.length; ++i) {
                ComponentAdapter compAdapter = this.get(sortedHandles[i]);
                if (compAdapter != null) {
                    Integer keyObj = sortedHandles[i];
                    tmpMap.put(keyObj, compAdapter);
                    this.m_map.remove(keyObj);
                    continue;
                }
                this.logger.warning("Invalid component handle '" + sortedHandles[i] + "' provided for component sorting. This means that ACS manager wrongly believes this container hosts a component with this handle.");
            }
            if (!this.m_map.isEmpty()) {
                Object missingHandles = "";
                for (int handle : this.m_map.keySet()) {
                    missingHandles = (String)missingHandles + handle + " ";
                }
                this.logger.info("Not enough component handles provided for sorting. Missing handles: " + (String)missingHandles);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Failed to sort components into correct shutdown order!", ex);
        }
        finally {
            this.m_map.putAll(tmpMap);
        }
    }

    synchronized ComponentAdapter remove(int compHandle) {
        return (ComponentAdapter)this.m_map.remove(compHandle);
    }

    synchronized ComponentAdapter get(int compHandle) {
        return this.m_map.get(compHandle);
    }

    synchronized ComponentAdapter[] getComponentAdapters(int[] compHandles) {
        ArrayList<ComponentAdapter> adapters = new ArrayList<ComponentAdapter>();
        if (compHandles != null) {
            for (int i = 0; i < compHandles.length; ++i) {
                ComponentAdapter adapter = this.get(compHandles[i]);
                if (adapter == null) continue;
                adapters.add(adapter);
            }
        }
        ComponentAdapter[] ret = adapters.toArray(new ComponentAdapter[adapters.size()]);
        return ret;
    }

    ComponentAdapter getComponentByNameAndType(String name, String type) {
        ComponentAdapter existingCompAdapter = null;
        ComponentAdapter[] compAdapters = this.getAllComponentAdapters();
        for (int i = 0; i < compAdapters.length; ++i) {
            ComponentAdapter otherAdapter = compAdapters[i];
            if (!otherAdapter.getName().equals(name) || !otherAdapter.getType().equals(type)) continue;
            existingCompAdapter = otherAdapter;
            break;
        }
        return existingCompAdapter;
    }

    synchronized ComponentAdapter[] getAllComponentAdapters() {
        ArrayList<ComponentAdapter> nonNullAdapters = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter compAdapter : this.m_map.values()) {
            if (compAdapter == null) continue;
            nonNullAdapters.add(compAdapter);
        }
        ComponentAdapter[] ret = nonNullAdapters.toArray(new ComponentAdapter[nonNullAdapters.size()]);
        return ret;
    }

    synchronized int[] getAllHandles() {
        Set<Integer> keys = this.m_map.keySet();
        int[] ret = new int[keys.size()];
        int index = 0;
        for (Integer key : keys) {
            ret[index] = key;
            ++index;
        }
        return ret;
    }
}

