/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.CBDescIn;
import alma.ACS.CBlong;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.util.ACSPorts;
import alma.maciErrType.CannotGetComponentEx;
import alma.maciErrType.CannotRegisterComponentEx;
import alma.maciErrType.ComponentConfigurationNotFoundEx;
import alma.maciErrType.ComponentNotAlreadyActivatedEx;
import alma.maciErrType.ComponentSpecIncompatibleWithActiveComponentEx;
import alma.maciErrType.IncompleteComponentSpecEx;
import alma.maciErrType.InvalidComponentSpecEx;
import alma.maciErrType.NoDefaultComponentEx;
import alma.maciErrType.NoPermissionEx;
import alma.maciErrType.wrappers.AcsJCannotGetComponentEx;
import alma.maciErrType.wrappers.AcsJCannotRegisterComponentEx;
import alma.maciErrType.wrappers.AcsJComponentConfigurationNotFoundEx;
import alma.maciErrType.wrappers.AcsJComponentNotAlreadyActivatedEx;
import alma.maciErrType.wrappers.AcsJComponentSpecIncompatibleWithActiveComponentEx;
import alma.maciErrType.wrappers.AcsJIncompleteComponentSpecEx;
import alma.maciErrType.wrappers.AcsJInvalidComponentSpecEx;
import alma.maciErrType.wrappers.AcsJNoDefaultComponentEx;
import alma.maciErrType.wrappers.AcsJNoPermissionEx;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import si.ijs.maci.Client;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ComponentSpec;
import si.ijs.maci.Manager;
import si.ijs.maci.ManagerHelper;

public class AcsManagerProxy {
    private volatile Manager m_manager;
    private final String m_managerLoc;
    private volatile int m_mgrHandle = 0;
    private final ORB m_orb;
    private final Logger m_logger;
    private volatile boolean m_shuttingDown;
    private Client m_managerClient;
    protected final java.lang.Object connectorLock = new java.lang.Object();
    protected final Thread connectorThread = new Thread("AcsManagerProxy.ConnectorThread"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                java.lang.Object object = AcsManagerProxy.this.connectorLock;
                synchronized (object) {
                    try {
                        AcsManagerProxy.this.connectorLock.wait();
                    }
                    catch (InterruptedException exc) {
                        break;
                    }
                }
                while (true) {
                    try {
                        if (AcsManagerProxy.this.isLoggedIn(false)) continue block9;
                        AcsManagerProxy.this.m_logger.finer("attempting (re-)login");
                        AcsManagerProxy.this.loginToManager(1);
                        continue block9;
                    }
                    catch (AcsJContainerEx e) {
                        try {
                            1.sleep(5000L);
                        }
                        catch (InterruptedException exc) {
                            break block9;
                        }
                    }
                }
            }
        }
    };

    public AcsManagerProxy(String managerLoc, ORB orb, Logger logger) {
        if (managerLoc == null) {
            throw new IllegalArgumentException("argument 'managerLoc' must not be null.");
        }
        this.m_managerLoc = managerLoc;
        this.m_orb = orb;
        this.m_logger = logger;
    }

    public synchronized Manager getManager() throws AcsJContainerEx {
        if (this.m_manager == null) {
            if (this.m_shuttingDown) {
                String msg = "call to getManager() fails while shutting down.";
                this.m_logger.fine(msg);
                AcsJContainerEx ex = new AcsJContainerEx();
                ex.setContextInfo(msg);
                throw ex;
            }
            this.m_logger.fine("Manager reference not available. Trying to resolve...");
            this.findManager(this.m_managerLoc, 0);
        }
        return this.m_manager;
    }

    protected void activateReloginToManagerIfDisconnected() {
        if (!this.connectorThread.isAlive()) {
            this.connectorThread.setDaemon(true);
            this.connectorThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRuntimeException(RuntimeException exc) {
        if (exc instanceof NO_PERMISSION || exc instanceof OBJECT_NOT_EXIST || exc instanceof TRANSIENT) {
            this.m_mgrHandle = 0;
            java.lang.Object object = this.connectorLock;
            synchronized (object) {
                this.connectorLock.notify();
            }
        } else if (!(exc instanceof TIMEOUT)) {
            this.m_logger.log(Level.INFO, "unexpected error occurred: please report this", exc);
            return;
        }
    }

    private synchronized void findManager(String managerLoc, int attempts) throws AcsJContainerEx {
        if (attempts < 0) {
            throw new IllegalArgumentException("Invalid number of attempts to contact the manager: " + attempts);
        }
        int currentAttempt = attempts;
        do {
            if (this.m_shuttingDown) {
                AcsJContainerEx ex = new AcsJContainerEx();
                ex.setContextInfo("Abandoned because we are shutting down.");
                throw ex;
            }
            try {
                Object object = this.m_orb.string_to_object(this.m_managerLoc);
                this.m_logger.finest("manager corbaloc '" + managerLoc + "' resolved.");
                this.m_manager = ManagerHelper.narrow((Object)object);
                if (this.m_manager == null) {
                    AcsJContainerEx ex = new AcsJContainerEx();
                    ex.setContextInfo("received null reference to ACS Manager.");
                    throw ex;
                }
                this.m_logger.finest("manager narrow successful.");
                attempts = 1;
                currentAttempt = 0;
            }
            catch (Throwable thr) {
                String msg = "Failed to obtain the manager reference from the corbaloc '" + this.m_managerLoc + "'. ";
                if (attempts == 0 || currentAttempt > 0) {
                    this.m_logger.log(Level.INFO, msg + "Will keep trying.");
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.m_logger.log(Level.WARNING, msg + thr.getMessage());
                AcsJContainerEx ex = new AcsJContainerEx(thr);
                ex.setContextInfo(msg);
                throw ex;
            }
            int n = currentAttempt = attempts == 0 ? 0 : currentAttempt - 1;
        } while (attempts == 0 || currentAttempt > 0);
    }

    public synchronized void loginToManager(Client managerClient, int attempts) throws AcsJContainerEx {
        this.m_managerClient = managerClient;
        this.loginToManager(attempts);
        if (attempts == 0) {
            this.activateReloginToManagerIfDisconnected();
        }
    }

    private synchronized void loginToManager(int attempts) throws AcsJContainerEx {
        if (this.m_shuttingDown) {
            String msg = "call to loginToManager(..) fails while shutting down.";
            this.m_logger.fine(msg);
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        if (this.isLoggedIn(false)) {
            this.m_logger.info("login to Manager requested while being logged in - will first log out...");
            this.logoutFromManager();
        }
        if (this.m_manager == null) {
            this.m_logger.fine("manager reference not yet available in method loginToManager; will try to find the manager first...");
            this.findManager(this.m_managerLoc, attempts);
        }
        try {
            ClientInfo ci = this.m_manager.login(this.m_managerClient);
            if (ci == null) {
                throw new NullPointerException("received null from manager.login()");
            }
            if (ci.h <= 0) {
                AcsJContainerEx ex = new AcsJContainerEx();
                ex.setContextInfo("Got invalid handle from manager login: " + ci.h);
                throw ex;
            }
            this.m_mgrHandle = ci.h;
        }
        catch (Throwable thr) {
            this.m_mgrHandle = 0;
            String msg = "Failed to login to manager.";
            this.m_logger.log(Level.WARNING, msg);
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        this.m_logger.fine("Manager login done, handle '" + this.m_mgrHandle + "' obtained.");
    }

    boolean isLoggedIn(boolean checkPing) {
        boolean loggedIn;
        boolean bl = loggedIn = this.m_manager != null && this.m_mgrHandle != 0;
        if (loggedIn && checkPing) {
            loggedIn = this.pingManager(2000L);
        }
        return loggedIn;
    }

    public boolean pingManager(long timeoutMillis) {
        boolean responding = false;
        long startTime = System.currentTimeMillis();
        PingManagerThread pingThread = new PingManagerThread();
        pingThread.start();
        do {
            responding = pingThread.isResponding();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - startTime < timeoutMillis);
        return responding;
    }

    public synchronized void logoutFromManager() {
        try {
            if (this.isLoggedIn(false)) {
                this.m_logger.fine("about to log out from manager...");
                this.m_manager.logout(this.m_mgrHandle);
                this.m_logger.fine("logged out from manager.");
            }
        }
        catch (Exception ex) {
            this.m_logger.log(Level.WARNING, "failed to log out gracefully from the manager...", ex);
        }
        finally {
            this.m_mgrHandle = 0;
            this.m_manager = null;
        }
    }

    public ComponentInfo[] get_component_info(int[] componentHandles, String name_wc, String type_wc, boolean active_only) throws AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        ComponentInfo[] compInfos = null;
        try {
            compInfos = this.m_manager.get_component_info(this.checkAndGetManagerHandle(), componentHandles, name_wc, type_wc, active_only);
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        if (compInfos == null) {
            throw new NullPointerException("Manager returned null ComponentInfo[]");
        }
        return compInfos;
    }

    public Object get_service(String service_url, boolean includeComponents) throws AcsJComponentNotAlreadyActivatedEx, AcsJCannotGetComponentEx, AcsJComponentConfigurationNotFoundEx, AcsJNoPermissionEx {
        int clientId = includeComponents ? this.checkAndGetManagerHandle() : 0;
        boolean activate = includeComponents;
        try {
            return this.m_manager.get_service(clientId, service_url, activate);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (ComponentNotAlreadyActivatedEx ex) {
            throw AcsJComponentNotAlreadyActivatedEx.fromComponentNotAlreadyActivatedEx((ComponentNotAlreadyActivatedEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
        catch (ComponentConfigurationNotFoundEx ex) {
            throw AcsJComponentConfigurationNotFoundEx.fromComponentConfigurationNotFoundEx((ComponentConfigurationNotFoundEx)ex);
        }
    }

    public Object get_component(int clientHandle, String component_url, boolean activate) throws AcsJCannotGetComponentEx, AcsJComponentNotAlreadyActivatedEx, AcsJComponentConfigurationNotFoundEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_component(clientHandle, component_url, activate);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (ComponentNotAlreadyActivatedEx ex) {
            throw AcsJComponentNotAlreadyActivatedEx.fromComponentNotAlreadyActivatedEx((ComponentNotAlreadyActivatedEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
        catch (ComponentConfigurationNotFoundEx ex) {
            throw AcsJComponentConfigurationNotFoundEx.fromComponentConfigurationNotFoundEx((ComponentConfigurationNotFoundEx)ex);
        }
    }

    public Object get_component_non_sticky(int clientHandle, String component_url) throws AcsJCannotGetComponentEx, AcsJComponentNotAlreadyActivatedEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_component_non_sticky(clientHandle, component_url);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (ComponentNotAlreadyActivatedEx ex) {
            throw AcsJComponentNotAlreadyActivatedEx.fromComponentNotAlreadyActivatedEx((ComponentNotAlreadyActivatedEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
    }

    public Object getComponentNonSticky(int clientHandle, String component_url) throws AcsJComponentNotAlreadyActivatedEx, AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_component_non_sticky(clientHandle, component_url);
        }
        catch (RuntimeException rtex) {
            this.handleRuntimeException(rtex);
            throw rtex;
        }
        catch (ComponentNotAlreadyActivatedEx ex) {
            throw AcsJComponentNotAlreadyActivatedEx.fromComponentNotAlreadyActivatedEx((ComponentNotAlreadyActivatedEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
    }

    public ComponentInfo get_default_component(int clientHandle, String componentIDLType) throws AcsJNoDefaultComponentEx, AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_default_component(clientHandle, componentIDLType);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (NoDefaultComponentEx ex) {
            throw AcsJNoDefaultComponentEx.fromNoDefaultComponentEx((NoDefaultComponentEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
    }

    public ComponentInfo get_dynamic_component(int clientHandle, ComponentSpec c, boolean mark_as_default) throws AcsJIncompleteComponentSpecEx, AcsJInvalidComponentSpecEx, AcsJComponentSpecIncompatibleWithActiveComponentEx, AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_dynamic_component(clientHandle, c, mark_as_default);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (IncompleteComponentSpecEx ex) {
            throw AcsJIncompleteComponentSpecEx.fromIncompleteComponentSpecEx((IncompleteComponentSpecEx)ex);
        }
        catch (InvalidComponentSpecEx ex) {
            throw AcsJInvalidComponentSpecEx.fromInvalidComponentSpecEx((InvalidComponentSpecEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
        catch (ComponentSpecIncompatibleWithActiveComponentEx ex) {
            throw AcsJComponentSpecIncompatibleWithActiveComponentEx.fromComponentSpecIncompatibleWithActiveComponentEx((ComponentSpecIncompatibleWithActiveComponentEx)ex);
        }
    }

    public ComponentInfo get_collocated_component(int clientHandle, ComponentSpec c, boolean mark_as_default, String target_component_url) throws AcsJIncompleteComponentSpecEx, AcsJInvalidComponentSpecEx, AcsJComponentSpecIncompatibleWithActiveComponentEx, AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.get_collocated_component(clientHandle, c, mark_as_default, target_component_url);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (IncompleteComponentSpecEx ex) {
            throw AcsJIncompleteComponentSpecEx.fromIncompleteComponentSpecEx((IncompleteComponentSpecEx)ex);
        }
        catch (InvalidComponentSpecEx ex) {
            throw AcsJInvalidComponentSpecEx.fromInvalidComponentSpecEx((InvalidComponentSpecEx)ex);
        }
        catch (CannotGetComponentEx ex) {
            throw AcsJCannotGetComponentEx.fromCannotGetComponentEx((CannotGetComponentEx)ex);
        }
        catch (ComponentSpecIncompatibleWithActiveComponentEx ex) {
            throw AcsJComponentSpecIncompatibleWithActiveComponentEx.fromComponentSpecIncompatibleWithActiveComponentEx((ComponentSpecIncompatibleWithActiveComponentEx)ex);
        }
    }

    public int register_component(String component_url, String type, Object component) throws AcsJCannotRegisterComponentEx, AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            return this.m_manager.register_component(this.checkAndGetManagerHandle(), component_url, type, component);
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
        catch (CannotRegisterComponentEx ex) {
            throw AcsJCannotRegisterComponentEx.fromCannotRegisterComponentEx((CannotRegisterComponentEx)ex);
        }
    }

    public void release_component(int clientHandle, String component_url, CBlong callback) throws AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            this.m_manager.release_component_async(clientHandle, component_url, callback, new CBDescIn());
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
    }

    public int force_release_component(int clientHandle, String curl) throws AcsJNoPermissionEx {
        if (!this.isLoggedIn(false)) {
            throw new IllegalStateException("Not logged in to the manager.");
        }
        try {
            int clientNumber = this.m_manager.force_release_component(clientHandle, curl);
            return clientNumber;
        }
        catch (RuntimeException exc) {
            this.handleRuntimeException(exc);
            throw exc;
        }
        catch (NoPermissionEx ex) {
            throw AcsJNoPermissionEx.fromNoPermissionEx((NoPermissionEx)ex);
        }
    }

    public int getManagerHandle() {
        return this.m_mgrHandle;
    }

    int checkAndGetManagerHandle() throws AcsJNoPermissionEx {
        int managerHandle = this.m_mgrHandle;
        if (managerHandle <= 0) {
            AcsJNoPermissionEx ex = new AcsJNoPermissionEx();
            ex.setReason("Currently not logged in with the acs manager.");
            ex.setID("client handle: " + managerHandle);
            throw ex;
        }
        return managerHandle;
    }

    public void shutdownNotify() {
        this.m_shuttingDown = true;
        this.connectorThread.interrupt();
    }

    public static String getLocalManagerCorbaloc() {
        String host = ACSPorts.getIP();
        String managerLoc = "corbaloc::" + host + ":" + ACSPorts.getManagerPort() + "/Manager";
        return managerLoc;
    }

    public AcsManagerProxy createInstance() {
        AcsManagerProxy inst = new AcsManagerProxy(this.m_managerLoc, this.m_orb, this.m_logger);
        return inst;
    }

    private class PingManagerThread
    extends Thread {
        boolean m_responding = false;

        PingManagerThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                AcsManagerProxy.this.m_manager.ping();
                this.m_responding = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        boolean isResponding() {
            return this.m_responding;
        }
    }
}

