/*
 * Decompiled with CFR 0.152.
 */
package alma.acacorrelator.ACACorrConfigValidator;

import alma.AccumModeMod.AccumMode;
import alma.AtmPhaseCorrectionMod.AtmPhaseCorrection;
import alma.BasebandNameMod.BasebandName;
import alma.CorrelationBitMod.CorrelationBit;
import alma.CorrelationModeMod.CorrelationMode;
import alma.Correlator.ACAPhaseSwitchingConfigurations;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.BinSwitching_t;
import alma.Correlator.ChannelAverageRegion;
import alma.Correlator.CorrelatorConfiguration;
import alma.Correlator.SpectralWindow;
import alma.NetSidebandMod.NetSideband;
import alma.ReceiverBandMod.ReceiverBand;
import alma.ReceiverSidebandMod.ReceiverSideband;
import alma.SidebandProcessingModeMod.SidebandProcessingMode;
import alma.StokesParameterMod.StokesParameter;
import alma.SwitchingModeMod.SwitchingMode;
import alma.SynthProfMod.SynthProf;
import alma.WindowFunctionMod.WindowFunction;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLParser;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.entity.xmlbinding.schedblock.ACABaseBandConfigT;
import alma.entity.xmlbinding.schedblock.ACACorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.ACASpectralWindowT;
import alma.entity.xmlbinding.schedblock.ACASpectrometerCorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.AbstractCorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.BaseBandSpecificationT;
import alma.entity.xmlbinding.schedblock.BeamSwitchingCycleT;
import alma.entity.xmlbinding.schedblock.FrequencySwitchingCycleT;
import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import alma.entity.xmlbinding.schedblock.types.AbstractCorrelatorConfigurationTLOOffsettingModeType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTPolnProductsType;
import alma.entity.xmlbinding.schedblock.types.SpectralSpecTSwitchingTypeType;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.entity.xmlbinding.valuetypes.TimeT;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;

class ACA_XMLUnmarshaller {
    static final Logger logger = Logger.getLogger(ACA_XMLUnmarshaller.class.getName());
    private static final AbstractSpectralWindowTPolnProductsType[] POLN_PRODS = new AbstractSpectralWindowTPolnProductsType[]{AbstractSpectralWindowTPolnProductsType.XX, AbstractSpectralWindowTPolnProductsType.YY, AbstractSpectralWindowTPolnProductsType.XX_YY, AbstractSpectralWindowTPolnProductsType.XX_YY_XY_YX};
    static final StokesParameter[][] STOKES = new StokesParameter[][]{{StokesParameter.XX}, {StokesParameter.YY}, {StokesParameter.XX, StokesParameter.YY}, {StokesParameter.XX, StokesParameter.YY, StokesParameter.XY, StokesParameter.YX}};
    static final String[] TIME_UNITS = new String[]{"ns", "us", "ms", "s", "min", "h", "d"};
    static final double[] TIME_FACTORS = new double[]{1.0E-9, 1.0E-6, 0.001, 1.0, 60.0, 3600.0, 86400.0};
    static final String[] FREQ_UNITS = new String[]{"Hz", "kHz", "MHz", "GHz"};
    static final double[] FREQ_FACTORS = new double[]{1.0, 1000.0, 1000000.0, 1.0E9};

    ACA_XMLUnmarshaller() {
    }

    public static CorrelatorConfiguration convert(SpectralSpecT spec) throws SBConversionException {
        CorrelatorConfiguration conf = new CorrelatorConfiguration();
        conf = ACA_XMLUnmarshaller.convertRoot(conf, spec);
        return conf;
    }

    static void check(boolean cond, String format, Object ... args) throws SBConversionException {
        if (!cond) {
            throw new SBConversionException(MessageFormat.format(format, args));
        }
    }

    static CorrelatorConfiguration convertRoot(CorrelatorConfiguration conf, SpectralSpecT spec) throws SBConversionException {
        ACACorrelatorConfigurationT acaCorrConf;
        block9: {
            conf.dumpDuration = 0L;
            conf.subScanDurationACA = 0L;
            String receiverBandName = spec.getFrequencySetup().getReceiverBand().toString();
            conf.receiverBand = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(ReceiverBand.class, ReceiverBand.class, receiverBandName);
            FrequencyT lo1Freq = spec.getFrequencySetup().getLO1Frequency();
            conf.LO1FrequencyMHz = ACA_XMLUnmarshaller.hzToMHz(ACA_XMLUnmarshaller.normalizeFrequency(lo1Freq));
            String recTypeName = spec.getReceiverType().toString();
            conf.receiverType = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(ReceiverSideband.class, ReceiverSideband.class, recTypeName);
            ACA_XMLUnmarshaller.check(spec.getSpectralSpecTChoice() != null, "There should be one of ACACorrelatorConfiguration or BLCorrelatorConfiguration or ACASpectrometerCorrelatorConfiguration.", new Object[0]);
            acaCorrConf = null;
            if (spec.getSpectralSpecTChoice().getACACorrelatorConfiguration() != null) {
                acaCorrConf = spec.getSpectralSpecTChoice().getACACorrelatorConfiguration();
            } else if (spec.getSpectralSpecTChoice().getACASpectrometerCorrelatorConfiguration() != null) {
                acaCorrConf = spec.getSpectralSpecTChoice().getACASpectrometerCorrelatorConfiguration();
            }
            ACA_XMLUnmarshaller.check(acaCorrConf != null, "There should be ACACorrelatorConfiguration or ACASpectrometerCorrelatorConfiguration.", new Object[0]);
            TimeT integDuration = acaCorrConf.getIntegrationDuration();
            conf.integrationDuration = ACA_XMLUnmarshaller.secTo100ns(ACA_XMLUnmarshaller.normalizeTime(integDuration));
            TimeT chAveDuration = acaCorrConf.getChannelAverageDuration();
            conf.channelAverageDuration = ACA_XMLUnmarshaller.secTo100ns(ACA_XMLUnmarshaller.normalizeTime(chAveDuration));
            String APCDataSetsName = acaCorrConf.getAPCDataSets().toString();
            ACA_XMLUnmarshaller.check(APCDataSetsName != null, "There should be aPCDataSets.", new Object[0]);
            try {
                String[] APCDataSetsNames = APCDataSetsName.split("\\+");
                AtmPhaseCorrection[] apcs = new AtmPhaseCorrection[APCDataSetsNames.length];
                for (int i = 0; i < apcs.length; ++i) {
                    apcs[i] = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(AtmPhaseCorrection.class, AtmPhaseCorrection.class, APCDataSetsNames[i]);
                }
                conf.APCDataSets = apcs;
            }
            catch (PatternSyntaxException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        conf.ACAPhaseSwConfig = new ACAPhaseSwitchingConfigurations();
        if (acaCorrConf instanceof ACACorrelatorConfigurationT) {
            conf.ACAPhaseSwConfig.doD180modulation = acaCorrConf.getACAPhaseSwitchingConfiguration().getDoD180modulation();
            conf.ACAPhaseSwConfig.doD180demodulation = acaCorrConf.getACAPhaseSwitchingConfiguration().getDoD180demodulation();
        } else if (acaCorrConf instanceof ACASpectrometerCorrelatorConfigurationT) {
            conf.ACAPhaseSwConfig.doD180modulation = ((ACASpectrometerCorrelatorConfigurationT)acaCorrConf).getACAPhaseSwitchingConfiguration().getDoD180modulation();
            conf.ACAPhaseSwConfig.doD180demodulation = ((ACASpectrometerCorrelatorConfigurationT)acaCorrConf).getACAPhaseSwitchingConfiguration().getDoD180demodulation();
        }
        return ACA_XMLUnmarshaller.convertBaseBands(conf, spec, (AbstractCorrelatorConfigurationT)acaCorrConf);
    }

    static CorrelatorConfiguration convertBaseBands(CorrelatorConfiguration conf, SpectralSpecT spec, AbstractCorrelatorConfigurationT acaCorrConf) throws SBConversionException {
        BinSwitching_t binSwMode = ACA_XMLUnmarshaller.createBinSwitching(spec);
        AccumMode cam = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(AccumMode.class, AccumMode.class, acaCorrConf.getCAM().toString());
        SidebandProcessingMode sidebandProcMode = SidebandProcessingMode.NONE;
        AbstractCorrelatorConfigurationTLOOffsettingModeType loOffsettingMode = acaCorrConf.getLOOffsettingMode();
        if (acaCorrConf.getEnable90DegreeWalshFunction()) {
            ACA_XMLUnmarshaller.check(2 != loOffsettingMode.getType(), "lOOffsettingMode should not not be {0} but {1} when enable90DegreeWalshFunction is true.", AbstractCorrelatorConfigurationTLOOffsettingModeType.THREE_LOS.toString(), loOffsettingMode.toString());
            sidebandProcMode = SidebandProcessingMode.PHASE_SWITCH_SEPARATION;
        } else {
            sidebandProcMode = 2 == loOffsettingMode.getType() ? SidebandProcessingMode.FREQUENCY_OFFSET_REJECTION : SidebandProcessingMode.NONE;
        }
        ACABaseBandConfigT[] bbList = null;
        if (acaCorrConf instanceof ACACorrelatorConfigurationT) {
            bbList = ((ACACorrelatorConfigurationT)acaCorrConf).getACABaseBandConfig();
        } else if (acaCorrConf instanceof ACASpectrometerCorrelatorConfigurationT) {
            bbList = ((ACASpectrometerCorrelatorConfigurationT)acaCorrConf).getACABaseBandConfig();
        }
        int numBB = bbList.length;
        BaseBandSpecificationT[] srcBB = new BaseBandSpecificationT[numBB];
        BaseBandSpecificationT[] bbSpecs = spec.getFrequencySetup().getBaseBandSpecification();
        ACA_XMLUnmarshaller.check(bbSpecs != null, "There should be at least one BaseBandSpecification.", new Object[0]);
        int i = 0;
        ACABaseBandConfigT[] aCABaseBandConfigTArray = bbList;
        int n = aCABaseBandConfigTArray.length;
        for (int j = 0; j < n; ++j) {
            ACABaseBandConfigT bb = aCABaseBandConfigTArray[j];
            String partId = bb.getBaseBandSpecificationRef().getPartId();
            for (BaseBandSpecificationT bbSpec : bbSpecs) {
                if (!bbSpec.getEntityPartId().equals(partId)) continue;
                srcBB[i] = bbSpec;
            }
            ACA_XMLUnmarshaller.check(srcBB[i] != null, "There is no corresponding BaseBandSpecification for {0}th(0 origin) ACABaseBandConfig.", i);
            ++i;
        }
        conf.baseBands = new BaseBandConfig[numBB];
        int i2 = 0;
        for (ACABaseBandConfigT bb : bbList) {
            CorrelationMode dataProducts;
            BasebandName bbName;
            conf.baseBands[i2] = new BaseBandConfig();
            conf.baseBands[i2].binSwitchingMode = binSwMode;
            conf.baseBands[i2].basebandName = bbName = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(BasebandName.class, BasebandName.class, srcBB[i2].getBaseBandName().toString());
            conf.baseBands[i2].use12GHzFilter = srcBB[i2].getUse12GHzFilter();
            conf.baseBands[i2].useUSB = srcBB[i2].getUseUSB();
            conf.baseBands[i2].CAM = cam;
            conf.baseBands[i2].dataProducts = dataProducts = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(CorrelationMode.class, CorrelationMode.class, bb.getDataProducts().toString());
            conf.baseBands[i2].sideBandSeparationMode = sidebandProcMode;
            conf.baseBands[i2].LO2FrequencyMHz = ACA_XMLUnmarshaller.hzToMHz(ACA_XMLUnmarshaller.normalizeFrequency(srcBB[i2].getLO2Frequency()));
            conf.baseBands[i2].centerFreqOfResidualDelayMHz = ACA_XMLUnmarshaller.hzToMHz(ACA_XMLUnmarshaller.normalizeFrequency(bb.getCenterFreqOfResidualDelay()));
            SpectralWindow[] spectralWindows = ACA_XMLUnmarshaller.convertSpectralWindows(bb, bbName);
            conf.baseBands[i2].spectralWindows = spectralWindows;
            ++i2;
        }
        return conf;
    }

    static SpectralWindow[] convertSpectralWindows(ACABaseBandConfigT bb, BasebandName bbName) throws SBConversionException {
        int numOfSW = bb.getACASpectralWindowCount();
        HashMap<Integer, Integer> swNumToSwIndex = new HashMap<Integer, Integer>();
        for (int swIdx = 0; swIdx < numOfSW; ++swIdx) {
            int swNum = ACA_XMLParser.XMLUnmarshalUtil.getSwNumberFromSwName(bb.getACASpectralWindow(swIdx).getName());
            swNumToSwIndex.put(swNum, swIdx + 1);
        }
        SpectralWindow[] spectralWindows = new SpectralWindow[numOfSW];
        for (int swIdx = 0; swIdx < numOfSW; ++swIdx) {
            WindowFunction wf;
            NetSideband sideBand;
            SpectralWindow sw = new SpectralWindow();
            ACASpectralWindowT srcSw = bb.getACASpectralWindow(swIdx);
            sw.name = srcSw.getName() == null ? "" : srcSw.getName();
            sw.centerFrequencyMHz = ACA_XMLUnmarshaller.hzToMHz(ACA_XMLUnmarshaller.normalizeFrequency(srcSw.getCenterFrequency()));
            sw.effectiveBandwidthMHz = ACA_XMLUnmarshaller.hzToMHz(ACA_XMLUnmarshaller.normalizeFrequency(srcSw.getEffectiveBandwidth()));
            sw.effectiveNumberOfChannels = srcSw.getEffectiveNumberOfChannels();
            sw.spectralAveragingFactor = srcSw.getSpectralAveragingFactor();
            sw.sideBand = sideBand = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(NetSideband.class, NetSideband.class, srcSw.getSideBand().toString());
            sw.associatedSpectralWindowNumberInPair = 0;
            int counterpartSwNum = srcSw.getAssociatedSpectralWindowNumberInPair();
            if (counterpartSwNum != 0) {
                ACA_XMLUnmarshaller.check(swNumToSwIndex.containsKey(counterpartSwNum), "There is no corresponding spectral window for spectral window {0} in {1}", srcSw.getName(), bbName);
                sw.associatedSpectralWindowNumberInPair = (Integer)swNumToSwIndex.get(counterpartSwNum);
            }
            sw.useThisSpectralWindow = srcSw.getUseThisSpectralWindow();
            sw.windowFunction = wf = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(WindowFunction.class, WindowFunction.class, srcSw.getWindowFunction().toString());
            ChannelAverageRegion[] chAveRegs = new ChannelAverageRegion[srcSw.getChannelAverageRegionCount()];
            for (int i = 0; i < chAveRegs.length; ++i) {
                chAveRegs[i] = new ChannelAverageRegion(srcSw.getChannelAverageRegion(i).getStartChannel(), srcSw.getChannelAverageRegion(i).getNumberChannels());
            }
            sw.channelAverageRegions = chAveRegs;
            sw.frqChProfReproduction = srcSw.getFrqChProfReproduction();
            sw.synthProf = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(SynthProf.class, SynthProf.class, srcSw.getSynthProf().toString());
            sw.correlationBits = CorrelationBit.BITS_2x2;
            sw.correlationNyquistOversampling = false;
            AbstractSpectralWindowTPolnProductsType polProd = srcSw.getPolnProducts();
            assert (POLN_PRODS.length == STOKES.length);
            sw.polnProductsSeq = null;
            for (int i = 0; i < POLN_PRODS.length; ++i) {
                if (POLN_PRODS[i].getType() != polProd.getType()) continue;
                sw.polnProductsSeq = (StokesParameter[])STOKES[i].clone();
            }
            ACA_XMLUnmarshaller.check(sw.polnProductsSeq != null, "'polnProducts' has a wrong value {0}", polProd.toString());
            sw.quantizationCorrection = true;
            spectralWindows[swIdx] = sw;
        }
        return spectralWindows;
    }

    static BinSwitching_t createBinSwitching(SpectralSpecT spec) throws SBConversionException {
        BinSwitching_t binSwMode = new BinSwitching_t();
        SpectralSpecTSwitchingTypeType swType = spec.getSwitchingType();
        ACA_XMLUnmarshaller.check(swType != null, "'switchingType' of SpectralSpecT should not be null.", new Object[0]);
        String swTypeName = swType.toString();
        SwitchingMode swMode = ACA_XMLUnmarshaller.getStaticFieldValueOfTypeWithName(SwitchingMode.class, SwitchingMode.class, swTypeName);
        switch (swMode.value()) {
            case 0: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                swMode = SwitchingMode.NO_SWITCHING;
            }
        }
        binSwMode.SwitchingType = swMode;
        if (binSwMode.SwitchingType.value() == 0) {
            binSwMode.numberOfPositions = 0;
            binSwMode.dwellTime = new long[0];
            binSwMode.deadTime = new long[0];
        } else {
            int nPos;
            ACA_XMLUnmarshaller.check(spec.getSpectralSpecTChoice2() != null, "There should be one of BeamSwitchingCycle or FrequencySwitchingCycle.", new Object[0]);
            BeamSwitchingCycleT beamSwCycle = spec.getSpectralSpecTChoice2().getBeamSwitchingCycle();
            FrequencySwitchingCycleT freqCycle = spec.getSpectralSpecTChoice2().getFrequencySwitchingCycle();
            ACA_XMLUnmarshaller.check(beamSwCycle == null || freqCycle == null, "Only one of FrequencySwitchingCycleT or BeamSwitchingCycleT can be specified but both exist.", new Object[0]);
            BeamSwitchingCycleT swCycle = beamSwCycle != null ? beamSwCycle : freqCycle;
            binSwMode.numberOfPositions = nPos = swCycle.getNumberOfPositions();
            binSwMode.dwellTime = new long[nPos];
            binSwMode.deadTime = new long[nPos];
            if (binSwMode.SwitchingType.value() == 4) {
                ACA_XMLUnmarshaller.check(freqCycle != null, "No FrequencySwitchingCycleT for {0}", binSwMode.SwitchingType);
                ACA_XMLUnmarshaller.check(nPos == freqCycle.getFrequencySwitchingStateCount(), "numberOfPositions conflicts with a number({0}) of FrequencySwitchingState.", freqCycle.getFrequencySwitchingStateCount());
                for (int i = 0; i < nPos; ++i) {
                    TimeT time = freqCycle.getFrequencySwitchingState(i).getDwellTime();
                    binSwMode.dwellTime[i] = ACA_XMLUnmarshaller.secTo100ns(ACA_XMLUnmarshaller.normalizeTime(time));
                    binSwMode.deadTime[i] = 0L;
                }
            } else if (binSwMode.SwitchingType.value() == 5) {
                ACA_XMLUnmarshaller.check(beamSwCycle != null, "No BeamSwitchingCycleT for {0}", binSwMode.SwitchingType);
                ACA_XMLUnmarshaller.check(nPos == beamSwCycle.getBeamSwitchingStateCount(), "numberOfPositions conflicts with a number({0}) of BeamSwitchingState", beamSwCycle.getBeamSwitchingStateCount());
                for (int i = 0; i < nPos; ++i) {
                    TimeT time = beamSwCycle.getBeamSwitchingState(i).getDwellTime();
                    binSwMode.dwellTime[i] = ACA_XMLUnmarshaller.secTo100ns(ACA_XMLUnmarshaller.normalizeTime(time));
                    time = beamSwCycle.getBeamSwitchingState(i).getTransition();
                    binSwMode.deadTime[i] = ACA_XMLUnmarshaller.secTo100ns(ACA_XMLUnmarshaller.normalizeTime(time));
                }
            } else assert (false);
        }
        return binSwMode;
    }

    static <T, VT> VT getStaticFieldValueOfTypeWithName(Class<T> clazz, Class<VT> fieldType, String fieldName) throws SBConversionException {
        try {
            Field field = clazz.getField(fieldName);
            ACA_XMLUnmarshaller.check(fieldType.isAssignableFrom(field.getType()), "{0} is a wrong field name for {1}.", fieldName, clazz.getName());
            return (VT)field.get(null);
        }
        catch (SecurityException e) {
            logger.log(Level.FINE, e.toString(), e);
            throw new SBConversionException(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.FINE, e.toString(), e);
            throw new SBConversionException(e.getMessage());
        }
        catch (SBConversionException e) {
            logger.log(Level.FINE, e.toString(), e);
            throw new SBConversionException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, e.toString(), e);
            throw new SBConversionException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, e.toString(), e);
            throw new SBConversionException(e.getMessage());
        }
    }

    static long secTo100ns(double sec) {
        double FACTOR_TO_100ns = 1.0E7;
        return Math.round(sec * 1.0E7);
    }

    static double normalizeTime(TimeT time) throws SBConversionException {
        assert (TIME_UNITS.length == TIME_FACTORS.length);
        int idx = ACA_XMLUnmarshaller.findFromStringArray(TIME_UNITS, time.getUnit());
        ACA_XMLUnmarshaller.check(idx >= 0, "Unit of TimeT should be one of {0} but {1}.", ACA_XMLUnmarshaller.join(TIME_UNITS, ", "), time.getUnit());
        assert (idx < TIME_FACTORS.length);
        return time.getContent() * TIME_FACTORS[idx];
    }

    static double hzToMHz(double freq) {
        return freq / 1000000.0;
    }

    static double normalizeFrequency(FrequencyT freq) throws SBConversionException {
        assert (FREQ_UNITS.length == FREQ_FACTORS.length);
        int idx = ACA_XMLUnmarshaller.findFromStringArray(FREQ_UNITS, freq.getUnit());
        ACA_XMLUnmarshaller.check(idx >= 0, "Unit of FrequencyT should be one of {0} but {1}.", ACA_XMLUnmarshaller.join(FREQ_UNITS, ", "), freq.getUnit());
        assert (idx < FREQ_FACTORS.length);
        return freq.getContent() * FREQ_FACTORS[idx];
    }

    static String join(String[] strs, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String str : strs) {
            sb.append(sep);
            sb.append(str);
            sep = separator;
        }
        return sb.toString();
    }

    static int findFromStringArray(String[] table, String target) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] != target && !table[i].equals(target)) continue;
            return i;
        }
        return -1;
    }
}

