/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.level;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalArgumentEx;
import alma.Logging.LoggingConfigurablePackage.LogLevels;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;

public enum AcsLogLevelDefinition {
    TRACE(1, "Trace"),
    DELOUSE(2, "Delouse"),
    DEBUG(3, "Debug"),
    INFO(4, "Info"),
    NOTICE(5, "Notice"),
    WARNING(6, "Warning"),
    ERROR(8, "Error"),
    CRITICAL(9, "Critical"),
    ALERT(10, "Alert"),
    EMERGENCY(11, "Emergency"),
    OFF(99, "Off");

    public final int value;
    public final String name;

    private AcsLogLevelDefinition(int val, String name) {
        this.value = val;
        this.name = name;
    }

    public static AcsLogLevelDefinition fromName(String name) throws AcsJIllegalArgumentEx {
        for (AcsLogLevelDefinition def : AcsLogLevelDefinition.values()) {
            if (!def.name.equals(name)) continue;
            return def;
        }
        AcsJIllegalArgumentEx ex = new AcsJIllegalArgumentEx();
        ex.setVariable("name");
        ex.setValue(name);
        throw ex;
    }

    public AcsLogLevelDefinition getNextHigherLevel() {
        AcsLogLevelDefinition next;
        if (this.ordinal() + 1 < AcsLogLevelDefinition.values().length && (next = AcsLogLevelDefinition.values()[this.ordinal() + 1]) != OFF) {
            return next;
        }
        return null;
    }

    public static AcsLogLevelDefinition fromInteger(int val) throws AcsJIllegalArgumentEx {
        for (AcsLogLevelDefinition def : AcsLogLevelDefinition.values()) {
            if (def.value != val) continue;
            return def;
        }
        AcsJIllegalArgumentEx ex = new AcsJIllegalArgumentEx();
        ex.setVariable("val");
        ex.setValue(Integer.toString(val));
        throw ex;
    }

    public static AcsLogLevelDefinition fromXsdLogLevel(LogLevel legalLogLevel) throws AcsJIllegalArgumentEx {
        return AcsLogLevelDefinition.fromInteger(Integer.parseInt(legalLogLevel.toString()));
    }

    public LogLevel toXsdLevel() {
        return LogLevel.valueOf((String)Integer.toString(this.value));
    }

    public static LogLevel xsdLevelFromInteger(int level) throws AcsJIllegalArgumentEx {
        return AcsLogLevelDefinition.fromInteger(level).toXsdLevel();
    }

    public boolean isEqualXsdLevel(LogLevel schemaLevel) {
        if (schemaLevel == null) {
            throw new IllegalArgumentException("'schemaLevel' must not be null");
        }
        return this.value == Integer.parseInt(schemaLevel.toString());
    }

    public static LogLevels createIdlLogLevelsFromXsd(boolean useDefault, UnnamedLogger xsdLevels) {
        return new LogLevels(useDefault, Short.parseShort(xsdLevels.getMinLogLevel().toString()), Short.parseShort(xsdLevels.getMinLogLevelLocal().toString()));
    }

    public static UnnamedLogger createXsdLogLevelsFromIdl(LogLevels idlLevels) throws AcsJIllegalArgumentEx {
        UnnamedLogger xsdLevels = new UnnamedLogger();
        xsdLevels.setMinLogLevel(AcsLogLevelDefinition.xsdLevelFromInteger(idlLevels.minLogLevel));
        xsdLevels.setMinLogLevelLocal(AcsLogLevelDefinition.xsdLevelFromInteger(idlLevels.minLogLevelLocal));
        return xsdLevels;
    }
}

