/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.formatters;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogRecord;
import alma.acs.logging.LogParameterUtil;
import alma.acs.logging.formatters.AcsLogFormatter;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.IsoDateFormat;
import alma.acs.util.XmlNormalizer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.logging.LogRecord;
import org.omg.CORBA.Any;

public class AcsXMLLogFormatter
extends AcsLogFormatter {
    @Override
    public Any formatAny(Any anyLogRecord, LogRecord logRecord) {
        String xmlLogRecord = this.format(logRecord);
        anyLogRecord.insert_string(xmlLogRecord);
        return anyLogRecord;
    }

    @Override
    public String format(LogRecord logRecord) {
        long priority;
        String uri;
        long logId;
        String hostName;
        String Routine;
        long line;
        AcsLogLevel acsLevel = AcsLogLevel.getNativeLevel(logRecord.getLevel());
        if (acsLevel == null) {
            return "";
        }
        AcsLogLevelDefinition acsCoreLevel = acsLevel.getAcsLevel();
        String levelName = acsLevel.getEntryName();
        String TimeStamp = IsoDateFormat.formatDate((Date)new Date(logRecord.getMillis()));
        LogParameterUtil logParamUtil = new LogParameterUtil(logRecord);
        StringBuffer sb = new StringBuffer("");
        sb.append("<");
        sb.append(levelName);
        sb.append(" ");
        sb.append("TimeStamp=\"" + TimeStamp + "\" ");
        String file = logRecord.getSourceClassName();
        if (file == null) {
            if (acsCoreLevel == AcsLogLevelDefinition.DEBUG) {
                sb.append("File=\"unknown\" ");
            }
        } else {
            sb.append("File=\"" + file + "\"  ");
        }
        if ((line = logParamUtil.extractLongProperty("Line", -1L)) < 0L) {
            if (acsCoreLevel == AcsLogLevelDefinition.TRACE || acsCoreLevel == AcsLogLevelDefinition.DEBUG) {
                sb.append("Line=\"0\" ");
            }
        } else {
            sb.append("Line=\"" + line + "\" ");
        }
        if ((Routine = logRecord.getSourceMethodName()) == null) {
            if (acsCoreLevel == AcsLogLevelDefinition.TRACE) {
                sb.append("Routine=\"unknown\" ");
            }
        } else {
            sb.append("Routine=\"" + this.maskAttribute(Routine) + "\" ");
        }
        if ((hostName = logParamUtil.extractStringProperty("HostName", null)) == null || hostName.length() == 0) {
            hostName = this.getLocalHostName();
        }
        sb.append("Host=\"" + hostName + "\" ");
        String process = logParamUtil.extractStringProperty("ProcessName", null);
        if (process != null) {
            sb.append("Process=\"" + process + "\" ");
        } else {
            process = logRecord.getLoggerName();
            if (process != null) {
                sb.append("Process=\"" + process + "\" ");
            }
        }
        String sourceObject = logParamUtil.extractStringProperty("SourceObject", null);
        if (sourceObject != null) {
            sb.append("SourceObject=\"" + sourceObject + "\" ");
        } else {
            sourceObject = logRecord.getLoggerName();
            if (sourceObject != null) {
                sb.append("SourceObject=\"" + sourceObject + "\" ");
            }
        }
        String threadName = logParamUtil.extractStringProperty("ThreadName", null);
        if (threadName != null && threadName.length() > 0) {
            sb.append("Thread=\"" + threadName + "\" ");
        } else if (logRecord.getThreadID() >= 0) {
            sb.append("Thread=\"" + logRecord.getThreadID() + "\" ");
        }
        String context = logParamUtil.extractStringProperty("Context", null);
        if (context != null) {
            sb.append("Context=\"" + context + "\" ");
        }
        if (acsCoreLevel.compareTo(AcsLogLevelDefinition.WARNING) >= 0) {
            String stackId = logParamUtil.extractStringProperty("StackId", null);
            if (stackId == null) {
                sb.append("StackId=\"unknown\" ");
            } else {
                sb.append("StackId=\"" + stackId + "\" ");
            }
            long stackLevel = logParamUtil.extractLongProperty("StackLevel", -1L);
            if (stackLevel < 0L) {
                sb.append("StackLevel=\"0\" ");
            } else {
                sb.append("StackLevel=\"" + stackLevel + "\" ");
            }
        }
        if ((logId = logRecord.getSequenceNumber()) >= 0L) {
            sb.append("LogId=\"" + logId + "\" ");
        }
        if ((uri = logParamUtil.extractStringProperty("Uri", null)) != null) {
            sb.append("Uri=\"" + uri + "\" ");
        }
        if ((priority = logParamUtil.extractLongProperty("Priority", acsCoreLevel.value)) != (long)acsCoreLevel.value) {
            sb.append("Priority=\"" + priority + "\" ");
        }
        if (logRecord instanceof AcsLogRecord) {
            String antenna;
            String array;
            String audience = ((AcsLogRecord)logRecord).getAudience();
            if (!audience.equals("")) {
                sb.append("Audience=\"" + audience + "\" ");
            }
            if (!(array = ((AcsLogRecord)logRecord).getArray()).equals("")) {
                sb.append("Array=\"" + array + "\" ");
            }
            if (!(antenna = ((AcsLogRecord)logRecord).getAntenna()).equals("")) {
                sb.append("Antenna=\"" + antenna + "\" ");
            }
        }
        sb.setCharAt(sb.lastIndexOf("") - 1, '>');
        if (logRecord.getMessage() != null) {
            sb.append(this.maskMessage(logRecord.getMessage()));
        }
        try {
            Throwable loggedThrowable = logRecord.getThrown();
            if (loggedThrowable != null) {
                StringWriter exWriter = new StringWriter();
                loggedThrowable.printStackTrace(new PrintWriter(exWriter));
                sb.append("<Data Name=\"LoggedException\">" + this.maskMessage(exWriter.toString()) + "</Data>");
            }
            for (Object param : logParamUtil.getNonSpecialPropertiesMapParameters()) {
                if (param instanceof Map) {
                    Map propertiesMap = (Map)param;
                    for (Object keyName : propertiesMap.keySet()) {
                        String value = this.maskEmptyDataContent(propertiesMap.get(keyName).toString());
                        sb.append("<Data Name=\"" + keyName.toString() + "\">" + this.maskMessage(value) + "</Data>");
                    }
                    continue;
                }
                String value = this.maskEmptyDataContent(param.toString());
                sb.append("<Data Name=\"LoggedParameter\">" + this.maskMessage(value) + "</Data>");
            }
        }
        catch (Exception e) {
            sb.append("<Data Name=\"DataConstructionError\">" + this.maskMessage(e.toString()) + "</Data>");
        }
        sb.append("</" + levelName + ">");
        String Log2 = sb.toString();
        return Log2;
    }

    private String maskMessage(String message) {
        String maskedMessage = "<![CDATA[" + message + "]]>";
        return maskedMessage;
    }

    private String maskAttribute(String attributeValue) {
        return XmlNormalizer.normalize((String)attributeValue);
    }

    private String maskEmptyDataContent(String content) {
        if (content == null || content.length() == 0) {
            return "N/A";
        }
        return content;
    }
}

