/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.domainspecific;

import alma.acs.logging.AcsLogRecord;
import alma.acs.logging.AcsLogger;
import java.util.logging.Level;

public class AntennaContextLogger {
    private final AcsLogger delegateLogger;

    public AntennaContextLogger(AcsLogger logger) {
        this.delegateLogger = logger;
        this.delegateLogger.addLoggerClass(this.getClass());
    }

    public void log(Level level, String msg, String audience, String array, String antenna) {
        AcsLogRecord lr = this.delegateLogger.createAcsLogRecord(level, msg);
        lr.setAudience(audience);
        lr.setArray(array);
        lr.setAntenna(antenna);
        this.delegateLogger.log(lr);
    }

    public void log(Level level, String msg, Throwable thr, String audience, String array, String antenna) {
        AcsLogRecord lr = this.delegateLogger.createAcsLogRecord(level, msg);
        lr.setThrown(thr);
        lr.setAudience(audience);
        lr.setArray(array);
        lr.setAntenna(antenna);
        this.delegateLogger.log(lr);
    }

    public void log(Level level, String msg, String array, String antenna) {
        AcsLogRecord lr = this.delegateLogger.createAcsLogRecord(level, msg);
        lr.setArray(array);
        lr.setAntenna(antenna);
        this.delegateLogger.log(lr);
    }

    public void log(Level level, String msg, Throwable thr, String array, String antenna) {
        AcsLogRecord lr = this.delegateLogger.createAcsLogRecord(level, msg);
        lr.setThrown(thr);
        lr.setArray(array);
        lr.setAntenna(antenna);
        this.delegateLogger.log(lr);
    }
}

