/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.adapters;

import alma.acs.logging.ClientLogManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class CommonsLoggingFactory
extends LogFactoryImpl {
    public static final String SCXML_LOGGER_NAME_PREFIX = "scxml";
    private final Map<String, Log> loggerMap = new HashMap<String, Log>();

    protected synchronized Log newInstance(String name) throws LogConfigurationException {
        StackTraceElement[] stackTrace;
        String loggerNameBase = null;
        for (StackTraceElement stackTraceElement : stackTrace = new Exception().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("org.apache.commons.scxml")) continue;
            loggerNameBase = SCXML_LOGGER_NAME_PREFIX;
            break;
        }
        if (loggerNameBase == null) {
            return super.newInstance(name);
        }
        Object myLog = this.loggerMap.get(loggerNameBase);
        if (myLog == null) {
            final String loggerNameBaseFinal = loggerNameBase;
            myLog = new Jdk14Logger(loggerNameBase){

                public Logger getLogger() {
                    return ClientLogManager.getAcsLogManager().getLoggerForCorba(loggerNameBaseFinal, true);
                }
            };
            this.loggerMap.put(loggerNameBase, (Log)myLog);
        }
        return myLog;
    }
}

