/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.AcsLogger;
import alma.acs.logging.RepeatGuard;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class RepeatGuardLogger {
    protected final RepeatGuard guard;
    private final AcsLogger logger;

    public RepeatGuardLogger(AcsLogger logger, long interval, TimeUnit timeUnit, int maxRepetitions) {
        this.guard = new RepeatGuard(interval, timeUnit, maxRepetitions);
        this.logger = logger;
        logger.addLoggerClass(this.getClass());
    }

    public static RepeatGuardLogger createTimeBasedRepeatGuardLogger(AcsLogger logger, long interval, TimeUnit timeUnit) {
        return new RepeatGuardLogger(logger, interval, timeUnit, -1);
    }

    public static RepeatGuardLogger createCounterBasedRepeatGuardLogger(AcsLogger logger, int maxRepetitions) {
        return new RepeatGuardLogger(logger, -1L, TimeUnit.SECONDS, maxRepetitions);
    }

    public void log(Level level, String message) {
        if (this.guard.checkAndIncrement()) {
            this.logger.log(level, message);
        }
    }

    public void log(Level level, String message, Throwable thr) {
        if (this.guard.checkAndIncrement()) {
            this.logger.log(level, message, thr);
        }
    }

    public boolean isLoggingEnabled() {
        return this.guard.checkAndIncrement();
    }
}

