/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.acs.util.ACSPorts;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.omg.CORBA.ORB;

public class NamingServiceRemoteDirectory {
    private static final String DEFAULT_REFERENCE = "iiop://" + ACSPorts.getIP() + ":" + ACSPorts.getNamingServicePort() + "/";
    private String reference = System.getProperty("NamingServiceRemoteDirectory.reference", this.reference);
    private Context context = null;

    public NamingServiceRemoteDirectory(ORB orb, Logger logger) {
        this.internalInitialize(orb, logger);
    }

    public Context getContext() {
        return this.context;
    }

    private void internalInitialize(ORB orb, Logger logger) {
        logger.info("Connecting to CORBA Naming Service with reference '" + this.reference + "'...");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        env.put("java.naming.provider.url", this.reference);
        env.put("java.naming.corba.orb", (String)orb);
        try {
            this.context = new InitialContext(env);
            logger.info("Connected to CORBA Naming Service with reference '" + this.reference + "'.");
        }
        catch (Throwable ex) {
            logger.info("Failed to connect to CORBA Naming Service with reference '" + this.reference + "'...");
            return;
        }
    }

    public String getReference() {
        return this.reference;
    }
}

