/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.ACS.CBDescIn;
import alma.ACS.CBDescOut;
import alma.ACS.CBlong;
import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalArgumentEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.ACSErrTypeOK.wrappers.ACSErrOKAcsJCompletion;
import alma.Logging.IllegalLogLevelsEx;
import alma.Logging.LoggingConfigurablePackage.LogLevels;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigException;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maciErrType.CannotDeactivateComponentEx;
import alma.maciErrType.CannotGetComponentEx;
import alma.maciErrType.CannotRegisterComponentEx;
import alma.maciErrType.ComponentConfigurationNotFoundEx;
import alma.maciErrType.ComponentDeactivationFailedEx;
import alma.maciErrType.ComponentDeactivationUncleanEx;
import alma.maciErrType.ComponentNotAlreadyActivatedEx;
import alma.maciErrType.ComponentSpecIncompatibleWithActiveComponentEx;
import alma.maciErrType.IncompleteComponentSpecEx;
import alma.maciErrType.InvalidComponentSpecEx;
import alma.maciErrType.NoDefaultComponentEx;
import alma.maciErrType.NoPermissionEx;
import alma.maciErrType.wrappers.AcsJCannotGetComponentEx;
import alma.maciErrType.wrappers.AcsJCannotRegisterComponentEx;
import alma.maciErrType.wrappers.AcsJComponentConfigurationNotFoundEx;
import alma.maciErrType.wrappers.AcsJComponentNotAlreadyActivatedEx;
import alma.maciErrType.wrappers.AcsJComponentSpecIncompatibleWithActiveComponentEx;
import alma.maciErrType.wrappers.AcsJIncompleteComponentSpecEx;
import alma.maciErrType.wrappers.AcsJInvalidComponentSpecEx;
import alma.maciErrType.wrappers.AcsJNoDefaultComponentEx;
import alma.maciErrType.wrappers.AcsJNoPermissionEx;
import com.cosylab.acs.maci.BadParametersException;
import com.cosylab.acs.maci.ClientInfo;
import com.cosylab.acs.maci.Component;
import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.ComponentSpec;
import com.cosylab.acs.maci.ComponentStatus;
import com.cosylab.acs.maci.ContainerInfo;
import com.cosylab.acs.maci.CoreException;
import com.cosylab.acs.maci.HandleHelper;
import com.cosylab.acs.maci.Manager;
import com.cosylab.acs.maci.NoDefaultComponentException;
import com.cosylab.acs.maci.NoResourcesException;
import com.cosylab.acs.maci.StatusHolder;
import com.cosylab.acs.maci.manager.CURLHelper;
import com.cosylab.acs.maci.plug.AdministratorProxy;
import com.cosylab.acs.maci.plug.ClientProxy;
import com.cosylab.acs.maci.plug.ComponentProxy;
import com.cosylab.acs.maci.plug.ContainerProxy;
import com.cosylab.acs.maci.plug.SynchronousAdministratorProxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import si.ijs.maci.AdministratorHelper;
import si.ijs.maci.Client;
import si.ijs.maci.ClientHelper;
import si.ijs.maci.Container;
import si.ijs.maci.ContainerHelper;
import si.ijs.maci.ManagerPOA;
import si.ijs.maci.PingCallback;
import si.ijs.maci.SynchronousAdministratorHelper;

public class ManagerProxyImpl
extends ManagerPOA {
    private Manager manager;
    private Logger logger;
    private AtomicInteger pendingRequests = new AtomicInteger(0);

    private void reportException(Throwable th) {
        this.logger.log(Level.SEVERE, th.getMessage(), th);
    }

    public ManagerProxyImpl(Manager manager, Logger logger) {
        assert (manager != null);
        assert (logger != null);
        this.manager = manager;
        this.logger = logger;
    }

    public boolean ping() {
        return true;
    }

    public void pingCB(PingCallback cb) {
        cb.ping(true);
    }

    public String domain_name() {
        this.pendingRequests.incrementAndGet();
        try {
            String string = this.manager.getDomain();
            return string;
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ContainerInfo[] get_container_info(int id, int[] h, String name_wc) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            si.ijs.maci.ContainerInfo invalidInfo = new si.ijs.maci.ContainerInfo("<invalid>", 0, null, new int[0]);
            si.ijs.maci.ContainerInfo[] retVal = null;
            ContainerInfo[] infos = this.manager.getContainerInfo(id, h, name_wc);
            if (infos != null) {
                retVal = new si.ijs.maci.ContainerInfo[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    retVal[i] = infos[i] == null ? invalidInfo : new si.ijs.maci.ContainerInfo(infos[i].getName(), infos[i].getHandle(), (Container)((ContainerProxy)infos[i].getContainer()).getClient(), infos[i].getComponents().toArray());
                }
            } else {
                retVal = new si.ijs.maci.ContainerInfo[]{};
            }
            si.ijs.maci.ContainerInfo[] containerInfoArray = retVal;
            return containerInfoArray;
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ClientInfo[] get_client_info(int id, int[] h, String name_wc) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            si.ijs.maci.ClientInfo invalidInfo = new si.ijs.maci.ClientInfo(0, null, new int[0], "<invalid>", 0);
            si.ijs.maci.ClientInfo[] retVal = null;
            ClientInfo[] infos = this.manager.getClientInfo(id, h, name_wc);
            if (infos != null) {
                retVal = new si.ijs.maci.ClientInfo[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    retVal[i] = infos[i] == null ? invalidInfo : new si.ijs.maci.ClientInfo(infos[i].getHandle(), ((ClientProxy)infos[i].getClient()).getClient(), infos[i].getComponents().toArray(), infos[i].getName(), ManagerProxyImpl.mapAccessRights(infos[i].getAccessRights()));
                }
            } else {
                retVal = new si.ijs.maci.ClientInfo[]{};
            }
            si.ijs.maci.ClientInfo[] clientInfoArray = retVal;
            return clientInfoArray;
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ComponentInfo[] get_component_info(int id, int[] h, String name_wc, String type_wc, boolean active_only) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            si.ijs.maci.ComponentInfo invalidInfo = new si.ijs.maci.ComponentInfo("<invalid>", "<invalid>", null, "<invalid>", new int[0], 0, "<invalid>", 0, 0, new String[0]);
            si.ijs.maci.ComponentInfo[] retVal = null;
            ComponentInfo[] infos = this.manager.getComponentInfo(id, h, name_wc, type_wc, active_only);
            if (infos != null) {
                retVal = new si.ijs.maci.ComponentInfo[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    if (infos[i] == null) {
                        retVal[i] = invalidInfo;
                        continue;
                    }
                    Object obj = null;
                    if (infos[i].getComponent() != null) {
                        obj = (Object)infos[i].getComponent().getObject();
                    }
                    String[] interfaces = infos[i].getInterfaces() != null ? infos[i].getInterfaces() : new String[]{};
                    retVal[i] = new si.ijs.maci.ComponentInfo(infos[i].getType(), infos[i].getCode(), obj, infos[i].getName(), infos[i].getClients().toArray(), infos[i].getContainer(), infos[i].getContainerName(), infos[i].getHandle(), ManagerProxyImpl.mapAccessRights(infos[i].getAccessRights()), interfaces);
                }
            } else {
                retVal = new si.ijs.maci.ComponentInfo[]{};
            }
            si.ijs.maci.ComponentInfo[] componentInfoArray = retVal;
            return componentInfoArray;
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public Object get_component(int id, String component_url, boolean activate) throws NoPermissionEx, CannotGetComponentEx, ComponentNotAlreadyActivatedEx, ComponentConfigurationNotFoundEx {
        this.pendingRequests.incrementAndGet();
        try {
            Component component;
            Object retVal = null;
            StatusHolder statusHolder = new StatusHolder();
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            if ((component = this.manager.getComponent(id, uri, activate, statusHolder)) != null) {
                retVal = (Object)component.getObject();
            }
            if (component == null || component.getObject() == null) {
                if (statusHolder.getStatus() == ComponentStatus.COMPONENT_NOT_ACTIVATED && !activate) {
                    AcsJComponentNotAlreadyActivatedEx ex = new AcsJComponentNotAlreadyActivatedEx();
                    ex.setCURL(component_url);
                    throw ex;
                }
                if (statusHolder.getStatus() == ComponentStatus.COMPONENT_DOES_NO_EXIST) {
                    AcsJComponentConfigurationNotFoundEx ex = new AcsJComponentConfigurationNotFoundEx();
                    ex.setCURL(component_url);
                    throw ex;
                }
                AcsJCannotGetComponentEx ex = new AcsJCannotGetComponentEx();
                ex.setCURL(component_url);
                throw ex;
            }
            Object object = retVal;
            return object;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJCannotGetComponentEx cgce) {
            throw cgce.toCannotGetComponentEx();
        }
        catch (AcsJComponentNotAlreadyActivatedEx cnaae) {
            throw cnaae.toComponentNotAlreadyActivatedEx();
        }
        catch (AcsJComponentConfigurationNotFoundEx ccnfe) {
            throw ccnfe.toComponentConfigurationNotFoundEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public Object get_component_non_sticky(int id, String component_url) throws NoPermissionEx, CannotGetComponentEx, ComponentNotAlreadyActivatedEx {
        this.pendingRequests.incrementAndGet();
        try {
            Component component;
            Object retVal = null;
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            if ((component = this.manager.getComponentNonSticky(id, uri)) != null) {
                retVal = (Object)component.getObject();
            }
            if (component == null) {
                throw new AcsJComponentNotAlreadyActivatedEx();
            }
            Object object = retVal;
            return object;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJCannotGetComponentEx cgce) {
            throw cgce.toCannotGetComponentEx();
        }
        catch (AcsJComponentNotAlreadyActivatedEx cnaae) {
            throw cnaae.toComponentNotAlreadyActivatedEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ClientInfo login(Client reference) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            ClientProxy clientProxy = null;
            if (reference != null) {
                if (reference._is_a(ContainerHelper.id())) {
                    clientProxy = new ContainerProxy(ContainerHelper.narrow((Object)reference));
                } else if (reference._is_a(SynchronousAdministratorHelper.id())) {
                    clientProxy = new SynchronousAdministratorProxy(SynchronousAdministratorHelper.narrow((Object)reference));
                } else if (reference._is_a(AdministratorHelper.id())) {
                    clientProxy = new AdministratorProxy(AdministratorHelper.narrow((Object)reference));
                } else if (reference._is_a(ClientHelper.id())) {
                    clientProxy = new ClientProxy(reference);
                } else {
                    BadParametersException af = new BadParametersException("Given reference does not implement 'maci::Client' interface.");
                    this.reportException(af);
                    throw new BAD_PARAM(af.getMessage());
                }
            }
            si.ijs.maci.ClientInfo retVal = null;
            ClientInfo info = this.manager.login(clientProxy);
            if (info != null) {
                retVal = new si.ijs.maci.ClientInfo(info.getHandle(), ((ClientProxy)info.getClient()).getClient(), info.getComponents().toArray(), info.getName(), ManagerProxyImpl.mapAccessRights(info.getAccessRights()));
            }
            si.ijs.maci.ClientInfo clientInfo = retVal;
            return clientInfo;
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void logout(int id) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            this.manager.logout(id);
        }
        catch (AcsJNoPermissionEx npe) {
            AcsJNoPermissionEx ex = new AcsJNoPermissionEx((Throwable)npe);
            ex.setReason(npe.getReason());
            ex.setID(HandleHelper.toString(id));
            throw ex.toNoPermissionEx();
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public int register_component(int id, String component_url, String type, Object component) throws NoPermissionEx, CannotRegisterComponentEx {
        this.pendingRequests.incrementAndGet();
        try {
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            int n = this.manager.registerComponent(id, uri, type, new ComponentProxy(component_url, component));
            return n;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (AcsJBadParameterEx bpe) {
            this.reportException(bpe);
            AcsJCannotRegisterComponentEx crce = new AcsJCannotRegisterComponentEx((Throwable)bpe);
            throw crce.toCannotRegisterComponentEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void make_component_immortal(int id, String component_url, boolean immortal_state) throws NoPermissionEx, ComponentNotAlreadyActivatedEx {
        this.pendingRequests.incrementAndGet();
        try {
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            this.manager.makeComponentImmortal(id, uri, immortal_state);
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new AcsJComponentNotAlreadyActivatedEx().toComponentNotAlreadyActivatedEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void release_component_async(int id, String component_url, CBlong callback, CBDescIn desc) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            final CBlong fcallback = callback;
            final CBDescOut descOut = new CBDescOut(0L, desc.id_tag);
            Manager.LongCompletionCallback lcc = null;
            if (callback != null) {
                lcc = new Manager.LongCompletionCallback(){

                    @Override
                    public void failed(int result, Throwable exception) {
                        if (exception instanceof AcsJException) {
                            AcsJException aex = (AcsJException)exception;
                            fcallback.done(result, aex.toAcsJCompletion().toCorbaCompletion(), descOut);
                        } else {
                            AcsJUnexpectedExceptionEx uex = new AcsJUnexpectedExceptionEx(exception);
                            fcallback.done(result, uex.toAcsJCompletion().toCorbaCompletion(), descOut);
                        }
                    }

                    @Override
                    public void done(int result) {
                        fcallback.done(result, new ACSErrOKAcsJCompletion().toCorbaCompletion(), descOut);
                    }
                };
            }
            this.manager.releaseComponentAsync(id, uri, lcc);
        }
        catch (AcsJNoPermissionEx nop) {
            this.reportException(nop);
            throw nop.toNoPermissionEx();
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public int release_component(int id, String component_url) throws CannotDeactivateComponentEx, ComponentDeactivationUncleanEx, ComponentDeactivationFailedEx, NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            int n = this.manager.releaseComponent(id, uri);
            return n;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public int force_release_component(int id, String component_url) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            int n = this.manager.forceReleaseComponent(id, uri);
            return n;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJBadParameterEx bpe) {
            this.reportException(bpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void shutdown(int id, int containers) {
        this.pendingRequests.incrementAndGet();
        try {
            this.manager.shutdown(id, containers);
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw new NO_PERMISSION(npe.getMessage());
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void unregister_component(int id, int h) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            this.manager.unregisterComponent(id, h);
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJBadParameterEx bpe) {
            this.reportException(bpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ComponentInfo get_default_component(int id, String type) throws NoPermissionEx, NoDefaultComponentEx, CannotGetComponentEx {
        this.pendingRequests.incrementAndGet();
        try {
            si.ijs.maci.ComponentInfo retVal = null;
            ComponentInfo info = this.manager.getDefaultComponent(id, type);
            if (info == null || info.getComponent() == null) {
                throw new AcsJCannotGetComponentEx();
            }
            Object obj = null;
            obj = (Object)info.getComponent().getObject();
            String[] interfaces = info.getInterfaces() != null ? info.getInterfaces() : new String[]{};
            si.ijs.maci.ComponentInfo componentInfo = retVal = new si.ijs.maci.ComponentInfo(info.getType(), info.getCode(), obj, info.getName(), info.getClients().toArray(), info.getContainer(), info.getContainerName(), info.getHandle(), ManagerProxyImpl.mapAccessRights(info.getAccessRights()), interfaces);
            return componentInfo;
        }
        catch (NoDefaultComponentException ndce) {
            NoDefaultComponentException hndce = new NoDefaultComponentException(ndce.getMessage(), ndce);
            this.reportException(hndce);
            throw new AcsJNoDefaultComponentEx().toNoDefaultComponentEx();
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (AcsJCannotGetComponentEx cgce) {
            throw cgce.toCannotGetComponentEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ComponentInfo get_dynamic_component(int id, si.ijs.maci.ComponentSpec c, boolean mark_as_default) throws NoPermissionEx, IncompleteComponentSpecEx, InvalidComponentSpecEx, ComponentSpecIncompatibleWithActiveComponentEx, CannotGetComponentEx {
        this.pendingRequests.incrementAndGet();
        try {
            si.ijs.maci.ComponentInfo retVal = null;
            ComponentSpec componentSpec = new ComponentSpec(c.component_name, c.component_type, c.component_code, c.container_name);
            ComponentInfo info = this.manager.getDynamicComponent(id, componentSpec, mark_as_default);
            if (info == null || info.getComponent() == null) {
                throw new AcsJCannotGetComponentEx();
            }
            Object obj = null;
            obj = (Object)info.getComponent().getObject();
            String[] interfaces = info.getInterfaces() != null ? info.getInterfaces() : new String[]{};
            si.ijs.maci.ComponentInfo componentInfo = retVal = new si.ijs.maci.ComponentInfo(info.getType(), info.getCode(), obj, info.getName(), info.getClients().toArray(), info.getContainer(), info.getContainerName(), info.getHandle(), ManagerProxyImpl.mapAccessRights(info.getAccessRights()), interfaces);
            return componentInfo;
        }
        catch (AcsJInvalidComponentSpecEx ics) {
            throw ics.toInvalidComponentSpecEx();
        }
        catch (AcsJIncompleteComponentSpecEx ics) {
            throw ics.toIncompleteComponentSpecEx();
        }
        catch (AcsJComponentSpecIncompatibleWithActiveComponentEx cpiwac) {
            throw cpiwac.toComponentSpecIncompatibleWithActiveComponentEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJCannotGetComponentEx cgce) {
            this.reportException(cgce);
            throw cgce.toCannotGetComponentEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public si.ijs.maci.ComponentInfo get_collocated_component(int id, si.ijs.maci.ComponentSpec c, boolean mark_as_default, String target_component) throws NoPermissionEx, IncompleteComponentSpecEx, InvalidComponentSpecEx, ComponentSpecIncompatibleWithActiveComponentEx, CannotGetComponentEx {
        this.pendingRequests.incrementAndGet();
        try {
            ComponentSpec componentSpec;
            ComponentInfo info;
            si.ijs.maci.ComponentInfo retVal = null;
            URI targetComponentURI = null;
            if (target_component != null) {
                targetComponentURI = CURLHelper.createURI(target_component);
            }
            if ((info = this.manager.getCollocatedComponent(id, componentSpec = new ComponentSpec(c.component_name, c.component_type, c.component_code, c.container_name), mark_as_default, targetComponentURI)) == null || info.getComponent() == null) {
                throw new AcsJCannotGetComponentEx();
            }
            Object obj = null;
            obj = (Object)info.getComponent().getObject();
            String[] interfaces = info.getInterfaces() != null ? info.getInterfaces() : new String[]{};
            si.ijs.maci.ComponentInfo componentInfo = retVal = new si.ijs.maci.ComponentInfo(info.getType(), info.getCode(), obj, info.getName(), info.getClients().toArray(), info.getContainer(), info.getContainerName(), info.getHandle(), ManagerProxyImpl.mapAccessRights(info.getAccessRights()), interfaces);
            return componentInfo;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (AcsJInvalidComponentSpecEx ics) {
            throw ics.toInvalidComponentSpecEx();
        }
        catch (AcsJIncompleteComponentSpecEx ics) {
            throw ics.toIncompleteComponentSpecEx();
        }
        catch (AcsJComponentSpecIncompatibleWithActiveComponentEx cpiwac) {
            throw cpiwac.toComponentSpecIncompatibleWithActiveComponentEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJCannotGetComponentEx cgce) {
            throw cgce.toCannotGetComponentEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public Object get_service(int id, String service_url, boolean activate) throws NoPermissionEx, CannotGetComponentEx {
        this.pendingRequests.incrementAndGet();
        try {
            Component component;
            Object retVal = null;
            StatusHolder statusHolder = new StatusHolder();
            URI uri = null;
            if (service_url != null) {
                uri = CURLHelper.createURI(service_url);
            }
            if ((component = this.manager.getService(id, uri, activate, statusHolder)) == null || (Object)component.getObject() == null) {
                throw new AcsJCannotGetComponentEx();
            }
            Object object = retVal = (Object)component.getObject();
            return object;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJCannotGetComponentEx cgce) {
            throw cgce.toCannotGetComponentEx();
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public Object restart_component(int id, String component_url) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            Component component;
            Object retVal = null;
            URI uri = null;
            if (component_url != null) {
                uri = CURLHelper.createURI(component_url);
            }
            if ((component = this.manager.restartComponent(id, uri)) != null) {
                retVal = (Object)component.getObject();
            }
            Object object = retVal;
            return object;
        }
        catch (URISyntaxException usi) {
            BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
            this.reportException(hbpe);
            throw new BAD_PARAM(usi.getMessage());
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJBadParameterEx bpe) {
            this.reportException(bpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void shutdown_container(int id, String container_name, int action) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            this.manager.shutdownContainer(id, container_name, action);
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void set_state_persistence(int id, boolean enable) throws NoPermissionEx {
        this.pendingRequests.incrementAndGet();
        try {
            this.manager.setStatePersistence(id, enable);
        }
        catch (BadParametersException bpe) {
            BadParametersException hbpe = new BadParametersException(bpe.getMessage(), bpe);
            this.reportException(hbpe);
            throw new BAD_PARAM(bpe.getMessage());
        }
        catch (NoResourcesException nre) {
            NoResourcesException hnre = new NoResourcesException(nre.getMessage(), nre);
            this.reportException(hnre);
            throw new NO_RESOURCES(nre.getMessage());
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe.toNoPermissionEx();
        }
        catch (Throwable ex) {
            CoreException hce = new CoreException(ex.getMessage(), ex);
            this.reportException(hce);
            throw new UNKNOWN(ex.getMessage());
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogLevels get_default_logLevels() {
        this.pendingRequests.incrementAndGet();
        try {
            LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
            LogLevels logLevels = new LogLevels();
            logLevels.useDefault = false;
            logLevels.minLogLevel = (short)logConfig.getDefaultMinLogLevel().value;
            logLevels.minLogLevelLocal = (short)logConfig.getDefaultMinLogLevelLocal().value;
            LogLevels logLevels2 = logLevels;
            return logLevels2;
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public void set_default_logLevels(LogLevels levels) throws IllegalLogLevelsEx {
        this.pendingRequests.incrementAndGet();
        LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
        try {
            logConfig.setDefaultMinLogLevel(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevel));
            logConfig.setDefaultMinLogLevelLocal(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevelLocal));
        }
        catch (AcsJIllegalArgumentEx ex) {
            IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
            throw ille;
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get_logger_names() {
        this.pendingRequests.incrementAndGet();
        try {
            LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
            Set loggerNames = logConfig.getLoggerNames();
            String[] stringArray = loggerNames.toArray(new String[loggerNames.size()]);
            return stringArray;
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogLevels get_logLevels(String logger_name) {
        this.pendingRequests.incrementAndGet();
        try {
            LogLevels ret;
            LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
            LogConfig.LockableUnnamedLogger levels = logConfig.getNamedLoggerConfig(logger_name);
            boolean useDefault = !logConfig.hasCustomConfig(logger_name);
            LogLevels logLevels = ret = AcsLogLevelDefinition.createIdlLogLevelsFromXsd((boolean)useDefault, (UnnamedLogger)levels);
            return logLevels;
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_logLevels(String logger_name, LogLevels levels) throws IllegalLogLevelsEx {
        block6: {
            this.pendingRequests.incrementAndGet();
            try {
                LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
                if (levels.useDefault) {
                    logConfig.clearNamedLoggerConfig(logger_name);
                    break block6;
                }
                try {
                    UnnamedLogger config = AcsLogLevelDefinition.createXsdLogLevelsFromIdl((LogLevels)levels);
                    logConfig.setNamedLoggerConfig(logger_name, config);
                }
                catch (AcsJIllegalArgumentEx ex) {
                    IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
                    throw ille;
                }
            }
            finally {
                this.pendingRequests.decrementAndGet();
            }
        }
    }

    public void refresh_logging_config() {
        this.pendingRequests.incrementAndGet();
        try {
            LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
            try {
                logConfig.initialize(true);
            }
            catch (LogConfigException ex) {
                this.logger.log(Level.FINE, "Failed to configure logging (default values will be used).", ex);
            }
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    public static int mapAccessRights(int accessRights) {
        int retVal = 0;
        if ((accessRights & 0x8000000) == 0x8000000) {
            retVal |= 0x8000000;
        }
        if ((accessRights & 0x2000000) == 0x2000000) {
            retVal |= 0x2000000;
        }
        if ((accessRights & 0x4000000) == 0x4000000) {
            retVal |= 0x4000000;
        }
        return retVal;
    }

    public int getNumberOfPendingRequests() {
        return this.pendingRequests.get();
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ManagerProxyImpl = { ");
        sbuff.append("manager = '");
        sbuff.append(this.manager);
        sbuff.append("' }");
        return new String(sbuff);
    }
}

