/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.ACS.CBDescIn;
import alma.ACS.CBDescOut;
import alma.ACSErr.Completion;
import alma.acs.exceptions.AcsJCompletion;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.ClientLogManager;
import alma.maciErrType.CannotActivateComponentEx;
import alma.maciErrType.CannotDeactivateComponentEx;
import alma.maciErrType.ComponentDeactivationFailedEx;
import alma.maciErrType.ComponentDeactivationUncleanEx;
import alma.maciErrType.wrappers.AcsJCannotActivateComponentEx;
import alma.maciErrType.wrappers.AcsJCannotDeactivateComponentEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import com.cosylab.acs.maci.Component;
import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.Container;
import com.cosylab.acs.maci.IntArray;
import com.cosylab.acs.maci.RemoteException;
import com.cosylab.acs.maci.TimeoutRemoteException;
import com.cosylab.acs.maci.plug.ClientProxy;
import com.cosylab.acs.maci.plug.ComponentProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.UNKNOWN;
import si.ijs.maci.CBComponentInfo;
import si.ijs.maci.CBComponentInfoPOA;
import si.ijs.maci.Client;
import si.ijs.maci.ContainerHelper;

public class ContainerProxy
extends ClientProxy
implements Container {
    private static final long serialVersionUID = -7485420616224721204L;
    protected si.ijs.maci.Container container;
    protected static final Logger logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("Manager-ContainerProxy", true);
    private CBComponentInfoImpl componentInfoCBServant;
    private CBComponentInfo componentInfoCB;

    public ContainerProxy(si.ijs.maci.Container container) {
        super((Client)container);
        this.container = container;
        this.ior = ContainerProxy.serialize((Object)container);
        this.activateCallback();
    }

    @Override
    public int get_handle() {
        try {
            return this.container.get_handle();
        }
        catch (TIMEOUT tex) {
            TimeoutRemoteException re = new TimeoutRemoteException("Timout occured while invoking 'get_handle()' method.", tex);
            throw re;
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'get_handle()' method.", ex);
            throw re;
        }
    }

    @Override
    public ComponentInfo activate_component(int handle, long executionId, String name, String exe, String type) throws AcsJCannotActivateComponentEx {
        try {
            si.ijs.maci.ComponentInfo info;
            ComponentInfo retVal = null;
            try {
                info = this.container.activate_component(handle, executionId, name, exe, type);
            }
            catch (CannotActivateComponentEx cannotActivateEx) {
                throw AcsJCannotActivateComponentEx.fromCannotActivateComponentEx((CannotActivateComponentEx)cannotActivateEx);
            }
            if (info != null) {
                retVal = new ComponentInfo(info.h, info.name, info.type, info.code, info.reference != null ? new ComponentProxy(info.name, info.reference) : null);
                retVal.setContainer(info.container);
                retVal.setContainerName(info.container_name);
                retVal.setAccessRights(ContainerProxy.inverseMapAccessRights(info.access));
                retVal.setClients(new IntArray(info.clients));
                retVal.setInterfaces(info.interfaces);
            }
            return retVal;
        }
        catch (TIMEOUT tex) {
            TimeoutRemoteException re = new TimeoutRemoteException("Timout occured while invoking 'activate_component()' method.", tex);
            throw re;
        }
        catch (MARSHAL marshalEx) {
            RemoteException re = new RemoteException("Failed to transform the paramters or return value of the container's 'activate_component' method to/from the corba call, using parameters name=" + name + ", exe=" + exe + ", type=" + type, marshalEx);
            throw re;
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'activate_component()' method.", ex);
            throw re;
        }
    }

    void activateCallback() {
        this.componentInfoCBServant = new CBComponentInfoImpl(this);
        this.componentInfoCB = this.componentInfoCBServant._this(ContainerProxy.getOrb());
    }

    @Override
    public void activate_component_async(int handle, long executionId, String name, String exe, String type, Container.ComponentInfoCompletionCallback callback) {
        CBDescIn cbIn = this.componentInfoCBServant.register(callback);
        try {
            this.container.activate_component_async(handle, executionId, name, exe, type, this.componentInfoCB, cbIn);
        }
        catch (TIMEOUT tex) {
            this.componentInfoCBServant.unregister(cbIn.id_tag);
            TimeoutRemoteException re = new TimeoutRemoteException("Timout occured while invoking 'activate_component()' method.", tex);
            throw re;
        }
        catch (MARSHAL marshalEx) {
            this.componentInfoCBServant.unregister(cbIn.id_tag);
            RemoteException re = new RemoteException("Failed to transform the paramters or return value of the container's 'activate_component' method to/from the corba call, using parameters name=" + name + ", exe=" + exe + ", type=" + type, marshalEx);
            throw re;
        }
        catch (Exception ex) {
            this.componentInfoCBServant.unregister(cbIn.id_tag);
            RemoteException re = new RemoteException("Failed to invoke 'activate_component()' method.", ex);
            throw re;
        }
    }

    @Override
    public void deactivate_component(int handle) throws AcsJCannotDeactivateComponentEx, AcsJComponentDeactivationUncleanEx, AcsJComponentDeactivationFailedEx {
        try {
            this.container.deactivate_component(handle);
        }
        catch (CannotDeactivateComponentEx cdce) {
            throw AcsJCannotDeactivateComponentEx.fromCannotDeactivateComponentEx((CannotDeactivateComponentEx)cdce);
        }
        catch (ComponentDeactivationUncleanEx cdue) {
            throw AcsJComponentDeactivationUncleanEx.fromComponentDeactivationUncleanEx((ComponentDeactivationUncleanEx)cdue);
        }
        catch (ComponentDeactivationFailedEx cdfe) {
            throw AcsJComponentDeactivationFailedEx.fromComponentDeactivationFailedEx((ComponentDeactivationFailedEx)cdfe);
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'deactivate_component()' method.", ex);
            throw re;
        }
    }

    @Override
    public ComponentInfo[] get_component_info(int[] handles) throws RemoteException {
        try {
            ComponentInfo[] retVal = null;
            si.ijs.maci.ComponentInfo[] infos = this.container.get_component_info(handles);
            if (infos != null) {
                retVal = new ComponentInfo[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    ComponentInfo componentInfo = new ComponentInfo(infos[i].h, infos[i].name, infos[i].type, infos[i].code, new ComponentProxy(infos[i].name, infos[i].reference));
                    componentInfo.setContainer(infos[i].container);
                    componentInfo.setContainerName(infos[i].container_name);
                    componentInfo.setAccessRights(ContainerProxy.inverseMapAccessRights(infos[i].access));
                    componentInfo.setClients(new IntArray(infos[i].clients));
                    componentInfo.setInterfaces(infos[i].interfaces);
                    retVal[i] = componentInfo;
                }
            }
            return retVal;
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'get_component_info()' method.", ex);
            throw re;
        }
    }

    @Override
    public Component restart_component(int handle) throws RemoteException {
        try {
            Object component = this.container.restart_component(handle);
            String componentName = "unknown";
            return new ComponentProxy("unknown", component);
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'restart_component()' method.", ex);
            throw re;
        }
    }

    @Override
    public void shutdown(int action) throws RemoteException {
        try {
            this.container.shutdown(action);
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'shutdown()' method.", ex);
            throw re;
        }
    }

    @Override
    public void set_component_shutdown_order(int[] handles) throws RemoteException {
        try {
            this.container.set_component_shutdown_order(handles);
        }
        catch (Exception ex) {
            RemoteException re = new RemoteException("Failed to invoke 'set_component_shutdown_order()' method.", ex);
            throw re;
        }
    }

    @Override
    public Client getClient() {
        return this.container;
    }

    public static int inverseMapAccessRights(int accessRights) {
        int retVal = 0;
        if ((accessRights & 0x8000000) == 0x8000000) {
            retVal |= 0x8000000;
        }
        if ((accessRights & 0x2000000) == 0x2000000) {
            retVal |= 0x2000000;
        }
        if ((accessRights & 0x4000000) == 0x4000000) {
            retVal |= 0x4000000;
        }
        return retVal;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.ior);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.ior = (String)stream.readObject();
            this.container = ContainerHelper.narrow((Object)ContainerProxy.deserialize(this.ior));
        }
        catch (Exception e) {
            this.container = null;
            this.ior = null;
        }
        this.activateCallback();
    }

    @Override
    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ContainerProxy = { ");
        sbuff.append("container = '");
        sbuff.append(this.container);
        sbuff.append("' }");
        return new String(sbuff);
    }

    public boolean equals(java.lang.Object obj) {
        if (this.container == null) {
            return obj == null;
        }
        if (obj instanceof si.ijs.maci.Container) {
            try {
                return this.container.toString().equals(((si.ijs.maci.Container)obj).toString());
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (obj instanceof ClientProxy) {
            try {
                return this.ior.equals(((ClientProxy)obj).ior);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    class CBComponentInfoImpl
    extends CBComponentInfoPOA {
        private Map<Integer, Container.ComponentInfoCompletionCallback> lookupTable = new HashMap<Integer, Container.ComponentInfoCompletionCallback>();
        private int id = 0;

        CBComponentInfoImpl(ContainerProxy this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CBDescIn register(Container.ComponentInfoCompletionCallback cb) {
            Map<Integer, Container.ComponentInfoCompletionCallback> map = this.lookupTable;
            synchronized (map) {
                while (this.lookupTable.containsKey(++this.id)) {
                }
                this.lookupTable.put(this.id, cb);
                return new CBDescIn(0L, 0L, this.id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Container.ComponentInfoCompletionCallback unregister(int id) {
            Map<Integer, Container.ComponentInfoCompletionCallback> map = this.lookupTable;
            synchronized (map) {
                return this.lookupTable.remove(id);
            }
        }

        public void working(si.ijs.maci.ComponentInfo value, Completion c, CBDescOut desc) {
        }

        public void done(si.ijs.maci.ComponentInfo info, Completion c, CBDescOut desc) {
            block8: {
                logger.log((Level)AcsLogLevel.DEBUG, "CBComponentInfo.done called with desc.id_tag = " + desc.id_tag);
                Container.ComponentInfoCompletionCallback cb = null;
                try {
                    cb = this.unregister(desc.id_tag);
                    if (cb != null) {
                        AcsJException ex;
                        ComponentInfo retVal = null;
                        if (info != null) {
                            retVal = new ComponentInfo(info.h, info.name, info.type, info.code, info.reference != null ? new ComponentProxy(info.name, info.reference) : null);
                            retVal.setContainer(info.container);
                            retVal.setContainerName(info.container_name);
                            retVal.setAccessRights(ContainerProxy.inverseMapAccessRights(info.access));
                            retVal.setClients(new IntArray(info.clients));
                            retVal.setInterfaces(info.interfaces);
                        }
                        if ((ex = AcsJCompletion.fromCorbaCompletion((Completion)c).getAcsJException()) == null) {
                            cb.done(retVal);
                        } else {
                            cb.failed(retVal, ex);
                        }
                        break block8;
                    }
                    NO_RESOURCES nr = new NO_RESOURCES("Unknown 'desc.id_tag' (" + desc.id_tag + ") parameter for CBComponentInfo.done received.");
                    logger.log((Level)AcsLogLevel.WARNING, nr.getMessage(), nr);
                    throw nr;
                }
                catch (NO_RESOURCES nre) {
                    throw nre;
                }
                catch (Throwable thr) {
                    logger.log(AcsLogLevel.SEVERE, "Failed to process data about a freshly activated component.", thr);
                    if (cb != null) {
                        cb.failed(null, thr);
                    }
                    throw new UNKNOWN("Unexpected exception caught while processing CBComponentInfo.done() callback.");
                }
            }
        }

        public boolean negotiate(long time_to_transmit, CBDescOut desc) {
            return false;
        }
    }
}

