/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.ContainerInfo;
import com.cosylab.acs.maci.IntArray;
import com.cosylab.acs.maci.RemoteException;
import com.cosylab.acs.maci.manager.ComponentInfoTopologicalSort;
import com.cosylab.acs.maci.manager.HandleDataStore;
import com.cosylab.acs.maci.manager.ReaderPreferenceReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentInfoTopologicalSortManager
implements Runnable {
    private HandleDataStore components;
    private HandleDataStore containers;
    private volatile boolean destroyed = false;
    private ReaderPreferenceReadWriteLock activationPendingRWLock;
    private HashSet dirtyContainerMap = new HashSet();
    private Object listLock = new Object();
    private ComponentInfo[] currentTSList = new ComponentInfo[0];
    private Set pendingContainerShutdown;
    private ThreadPoolExecutor threadPool;
    private Logger logger;
    private Map pendingContainerNotifications = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfoTopologicalSortManager(HandleDataStore components, HandleDataStore containers, ReaderPreferenceReadWriteLock activationPendingRWLock, Set pendingContainerShutdown, ThreadPoolExecutor threadPool, Logger logger) {
        this.components = components;
        this.containers = containers;
        this.activationPendingRWLock = activationPendingRWLock;
        this.pendingContainerShutdown = pendingContainerShutdown;
        this.threadPool = threadPool;
        this.logger = logger;
        HandleDataStore handleDataStore = containers;
        synchronized (handleDataStore) {
            int h = containers.first();
            while (h != 0) {
                int containerHandle = ((ContainerInfo)containers.get(h)).getHandle();
                HashSet hashSet = this.dirtyContainerMap;
                synchronized (hashSet) {
                    this.dirtyContainerMap.add(containerHandle);
                }
                h = containers.next(h);
            }
        }
        new Thread((Runnable)this, "ComponentInfoTopologicalSortManager").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.destroyed) {
            ComponentInfoTopologicalSortManager componentInfoTopologicalSortManager = this;
            synchronized (componentInfoTopologicalSortManager) {
                int dirtyContainersCount;
                HashSet hashSet = this.dirtyContainerMap;
                synchronized (hashSet) {
                    dirtyContainersCount = this.dirtyContainerMap.size();
                }
                if (dirtyContainersCount == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            if (this.destroyed) {
                return;
            }
            this.activationPendingRWLock.writeLock().lock();
            try {
                ComponentInfo[] orderedList;
                Integer[] conts;
                HashSet dirtyContainersCount = this.dirtyContainerMap;
                synchronized (dirtyContainersCount) {
                    conts = new Integer[this.dirtyContainerMap.size()];
                    this.dirtyContainerMap.toArray(conts);
                    this.dirtyContainerMap.clear();
                }
                Object e = this.components;
                synchronized (e) {
                    List list = ComponentInfoTopologicalSort.sort(this.components);
                    orderedList = new ComponentInfo[list.size()];
                    list.toArray(orderedList);
                }
                e = this.listLock;
                synchronized (e) {
                    this.currentTSList = orderedList;
                }
                for (int i = 0; i < conts.length; ++i) {
                    int handle = conts[i] & 0xFFFF;
                    ContainerInfo containerInfo = null;
                    HandleDataStore handleDataStore = this.containers;
                    synchronized (handleDataStore) {
                        if (this.containers.isAllocated(handle)) {
                            containerInfo = (ContainerInfo)this.containers.get(handle);
                        }
                    }
                    if (containerInfo == null) break;
                    if (containerInfo.getName() == null) {
                        break;
                    }
                    String containerName = containerInfo.getName();
                    if (this.pendingContainerShutdown.contains(containerName)) {
                        break;
                    }
                    IntArray containerOrderdList = new IntArray(10);
                    for (int j = 0; j < orderedList.length; ++j) {
                        if (orderedList[j].getContainer() == 0 || !containerName.equals(orderedList[j].getContainerName())) continue;
                        containerOrderdList.add(orderedList[j].getHandle());
                    }
                    if (containerOrderdList.size() <= 1) continue;
                    this.notifyContainerShutdownOrder(containerInfo, containerOrderdList.toArray());
                }
            }
            finally {
                this.activationPendingRWLock.writeLock().unlock();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.logger.log(Level.WARNING, "Exception caught while waiting in run() method");
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTopologicalSort() {
        this.activationPendingRWLock.writeLock().lock();
        try {
            ComponentInfo[] orderedList;
            Object object = this.components;
            synchronized (object) {
                List list = ComponentInfoTopologicalSort.sort(this.components);
                orderedList = new ComponentInfo[list.size()];
                list.toArray(orderedList);
            }
            object = this.listLock;
            synchronized (object) {
                this.currentTSList = orderedList;
            }
        }
        finally {
            this.activationPendingRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyTopologyChange(int containerHandleToNotify) {
        HashSet hashSet = this.dirtyContainerMap;
        synchronized (hashSet) {
            this.dirtyContainerMap.add(containerHandleToNotify);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo[] getComponentShutdownOrder(ContainerInfo containerInfo) {
        ComponentInfo[] orderedList;
        if (containerInfo == null) {
            Object object = this.listLock;
            synchronized (object) {
                return this.currentTSList;
            }
        }
        String containerName = containerInfo.getName();
        Object object = this.listLock;
        synchronized (object) {
            orderedList = this.currentTSList;
        }
        ArrayList<ComponentInfo> containerOrderdList = new ArrayList<ComponentInfo>(10);
        for (int j = 0; j < orderedList.length; ++j) {
            if (orderedList[j].getContainer() == 0 || !containerName.equals(orderedList[j].getContainerName())) continue;
            containerOrderdList.add(orderedList[j]);
        }
        ComponentInfo[] retVal = new ComponentInfo[containerOrderdList.size()];
        containerOrderdList.toArray(retVal);
        return retVal;
    }

    public synchronized void destroy() {
        this.destroyed = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContainerShutdownOrder(ContainerInfo containerInfo, int[] handles) {
        Map map = this.pendingContainerNotifications;
        synchronized (map) {
            class ContainerSetShutdownOrderTask
            implements Runnable {
                private boolean done = false;
                private int[] handles;
                private ContainerInfo containerInfo;

                public ContainerSetShutdownOrderTask(ContainerInfo containerInfo, int[] handles) {
                    this.containerInfo = containerInfo;
                    this.handles = handles;
                }

                public synchronized boolean addNotification(int[] handles) {
                    if (this.done) {
                        return false;
                    }
                    this.handles = handles;
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int MAX_RETRIES = 3;
                    for (int retries = 0; retries < 3; ++retries) {
                        ContainerSetShutdownOrderTask containerSetShutdownOrderTask;
                        int[] hs = null;
                        try {
                            containerSetShutdownOrderTask = this;
                            synchronized (containerSetShutdownOrderTask) {
                                hs = this.handles;
                            }
                            this.containerInfo.getContainer().set_component_shutdown_order(hs);
                            containerSetShutdownOrderTask = this;
                            synchronized (containerSetShutdownOrderTask) {
                                if (this.handles == hs) {
                                    this.done = true;
                                    break;
                                }
                                retries = 0;
                                continue;
                            }
                        }
                        catch (RemoteException re) {
                            ComponentInfoTopologicalSortManager.this.logger.log(Level.SEVERE, "RemoteException caught while invoking 'Container.set_component_shutdown_order' on " + this.containerInfo + ".", re);
                        }
                        catch (Throwable ex) {
                            ComponentInfoTopologicalSortManager.this.logger.log(Level.SEVERE, "Unhandled exception caught while invoking 'Container.set_component_shutdown_order' on " + this.containerInfo + ".", ex);
                        }
                        containerSetShutdownOrderTask = this;
                        synchronized (containerSetShutdownOrderTask) {
                            if (this.handles != hs) {
                                --retries;
                            }
                            continue;
                        }
                    }
                }
            }
            ContainerSetShutdownOrderTask task = (ContainerSetShutdownOrderTask)this.pendingContainerNotifications.get(containerInfo);
            if (task == null || !task.addNotification(handles)) {
                try {
                    this.threadPool.execute(new ContainerSetShutdownOrderTask(containerInfo, handles));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }
}

