/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.flatfile;

import alma.common.sourcecatalog.Catalog;
import alma.common.sourcecatalog.CatalogAccess;
import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.SimpleSource;
import alma.common.sourcecatalog.Source;
import alma.common.sourcecatalog.SourceType;
import alma.common.sourcecatalog.flatfile.CatalogImporter;
import alma.common.sourcecatalog.flatfile.FlatFileSortField;
import alma.common.sourcecatalog.flatfile.MeasurementFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CatalogAccessFlatFile
implements CatalogAccess {
    private static volatile CatalogAccessFlatFile instance = null;
    private final Collection<Measurement> measurements;
    private final Map<Integer, Collection<Measurement>> bySource = new HashMap<Integer, Collection<Measurement>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CatalogAccessFlatFile getInstance() {
        if (instance != null) return instance;
        Class<CatalogAccessFlatFile> clazz = CatalogAccessFlatFile.class;
        synchronized (CatalogAccessFlatFile.class) {
            instance = new CatalogAccessFlatFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CatalogAccessFlatFile() {
        Collection<Measurement> pool;
        try {
            CatalogImporter caltab = CatalogImporter.getInstance();
            pool = caltab.getCalibratorList();
        }
        catch (IOException e) {
            e.printStackTrace();
            pool = Collections.emptyList();
        }
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        measurements.addAll(pool);
        this.measurements = Collections.unmodifiableCollection(measurements);
        for (Measurement m : measurements) {
            int sourceId = m.getSourceId();
            if (this.bySource.containsKey(sourceId)) {
                this.bySource.get(sourceId).add(m);
                continue;
            }
            this.bySource.put(sourceId, new ArrayList());
            this.bySource.get(sourceId).add(m);
        }
    }

    @Override
    public Collection<Catalog> listCatalogs() throws IOException {
        Catalog c = new Catalog(this){

            @Override
            public int getId() {
                return 0;
            }

            @Override
            public String getName() {
                return "SMA";
            }
        };
        ArrayList<1> catalogs = new ArrayList<1>();
        catalogs.add(c);
        return Collections.unmodifiableCollection(catalogs);
    }

    @Override
    public List<Measurement> query(CatalogQueryParameters query) {
        List<Measurement> filtered = MeasurementFilter.filterMeasurements(this.measurements, query);
        return filtered;
    }

    @Override
    public Collection<String> listSortFields() {
        return FlatFileSortField.listSortFields();
    }

    @Override
    public Collection<SourceType> listTypes() {
        return Collections.emptyList();
    }

    @Override
    public Source getSource(Integer id) {
        if (this.bySource.containsKey(id)) {
            Collection<Measurement> c = this.bySource.get(id);
            return new SimpleSource(c);
        }
        return null;
    }
}

