/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.CoordinateConverter;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageDisplayStatusPanel;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.gui.ImageZoom;
import jsky.image.gui.MainImageDisplay;
import jsky.image.gui.PickObjectGUI;
import jsky.image.gui.PickObjectStatistics;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;

public class PickObject
extends PickObjectGUI
implements ImageGraphicsHandler,
ChangeListener {
    private static final I18N _I18N = I18N.getInstance(PickObject.class);
    public static final int IMAGE_SIZE = 200;
    public static final int IMAGE_ZOOM = 10;
    private MainImageDisplay _mainImageDisplay;
    private ImageZoom _imageZoom;
    private BasicImageDisplay _imageDisplay;
    private MouseListener _pickObjectListener;
    private int _zoomWidth;
    private PickObjectStatistics _stats;
    private Stroke _bgStroke = new BasicStroke(5.0f);
    private Stroke _fgStroke = new BasicStroke(3.0f);
    private boolean _pickMode = false;
    private boolean _updating = false;

    public PickObject(MainImageDisplay mainImageDisplay) {
        this._mainImageDisplay = mainImageDisplay;
        this._imageZoom = new ImageZoom(this._mainImageDisplay, 200, 200, 10.0f);
        this._imageZoom.setActive(false);
        this._imageZoom.setPropagateScale(false);
        this.imagePanel.add(this._imageZoom);
        this._imageDisplay = this._imageZoom.getImageDisplay();
        this._imageDisplay.addImageGraphicsHandler(this);
        this._mainImageDisplay.addImageGraphicsHandler(this);
        this._mainImageDisplay.addChangeListener(this);
        this.zoomInButton.setIcon(Resources.getIcon((String)"ZoomIn24.gif"));
        this.zoomInButton.setText("");
        this.zoomOutButton.setIcon(Resources.getIcon((String)"ZoomOut24.gif"));
        this.zoomOutButton.setText("");
    }

    public void pickObject() {
        this._imageZoom.setActive(true);
        this._imageZoom.updateRect();
        if (!this._mainImageDisplay.isWCS()) {
            DialogUtil.error((Component)this, (String)_I18N.getString("thisImageNoWCSError"));
            return;
        }
        if (this._mainImageDisplay.getFitsImage() == null) {
            DialogUtil.error((Component)this, (String)_I18N.getString("thisFeatureOnlyForFITSError"));
            return;
        }
        if (this._pickObjectListener == null) {
            this._pickObjectListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!PickObject.this.isAutoAddMode()) {
                        PickObject.this._cancel();
                    }
                    PickObject.this._pickedObject();
                }
            };
        }
        Component c = (Component)((Object)this._mainImageDisplay);
        c.removeMouseListener(this._pickObjectListener);
        c.addMouseListener(this._pickObjectListener);
        c.setCursor(Cursor.getPredefinedCursor(1));
        this.pickButton.setText(_I18N.getString("cancel"));
        this._pickMode = true;
        this._stats = null;
    }

    public PickObjectStatistics getStatistics() {
        return this._stats;
    }

    public void addActionListener(ActionListener l) {
        this.addButton.removeActionListener(l);
        this.addButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.addButton.removeActionListener(l);
    }

    public boolean isAutoAddMode() {
        return this.autoAddCheckBox.isSelected();
    }

    public boolean isUpdate() {
        return this._updating;
    }

    private void _pickedObject() {
        Point2D.Double p = this._imageDisplay.getOrigin();
        this._imageDisplay.getCoordinateConverter().canvasToUserCoords(p, false);
        int zoomScale = (int)this._imageDisplay.getScale();
        this._zoomWidth = ((Component)((Object)this._imageDisplay)).getWidth() / zoomScale;
        this._stats = new PickObjectStatistics(this._mainImageDisplay, (int)p.x, (int)p.y, this._zoomWidth, this._zoomWidth);
        this._updateDisplay();
        if (this.isAutoAddMode()) {
            this.addButton.setEnabled(true);
            this.addButton.doClick();
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private void _updateDisplay() {
        NumberFormat nf = ImageDisplayStatusPanel.nf;
        this.imageXField.setText(nf.format(this._stats.getImageX()));
        this.imageYField.setText(nf.format(this._stats.getImageY()));
        this.raField.setText(this._stats.getCenterPos().getRA().toString());
        this.decField.setText(this._stats.getCenterPos().getDec().toString());
        this.equinoxField.setText("2000");
        if (this._stats.getStatus()) {
            this.fwhmField.setForeground(Color.black);
            this.fwhmField.setText(nf.format(this._stats.getFwhmX()) + " : " + nf.format(this._stats.getFwhmY()));
        } else {
            this.fwhmField.setForeground(Color.red);
            this.fwhmField.setText(_I18N.getString("cantDo"));
        }
        this.angleField.setText(nf.format(this._stats.getAngle()));
        this.peakField.setText(nf.format(this._stats.getObjectPeak()));
        this.backgroundField.setText(nf.format(this._stats.getMeanBackground()));
        this.pixelsField.setText(nf.format(this._zoomWidth));
        ((Component)((Object)this._imageDisplay)).repaint();
        ((Component)((Object)this._mainImageDisplay)).repaint();
    }

    @Override
    void pickObject(ActionEvent e) {
        if (this._pickMode) {
            this._cancel();
        } else {
            this.pickObject();
        }
        this.addButton.setEnabled(false);
    }

    private void _cancel() {
        Component c = (Component)((Object)this._mainImageDisplay);
        c.removeMouseListener(this._pickObjectListener);
        this._imageZoom.setActive(false);
        c.setCursor(Cursor.getPredefinedCursor(0));
        this.pickButton.setText(_I18N.getString("pick"));
        this._pickMode = false;
    }

    @Override
    void close(ActionEvent e) {
        this._cancel();
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }

    @Override
    void add(ActionEvent e) {
        this.addButton.setEnabled(false);
    }

    @Override
    void zoomIn(ActionEvent e) {
        this._zoom(true);
    }

    @Override
    void zoomOut(ActionEvent e) {
        this._zoom(false);
    }

    private void _zoom(boolean in) {
        float scale = this._imageDisplay.getScale();
        scale = in ? (scale >= 50.0f ? 50.0f : (scale += 1.0f)) : (scale <= 2.0f ? 2.0f : (scale -= 1.0f));
        this._imageDisplay.setScale(scale);
        this._imageDisplay.updateImage();
        this._magChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _magChanged() {
        float zoomScale = this._imageDisplay.getScale();
        this.magLabel.setText("" + (int)zoomScale + "x");
        Component c = (Component)((Object)this._imageDisplay);
        int w = c.getWidth();
        this._zoomWidth = (int)((float)w / zoomScale);
        if (this._stats != null) {
            Point2D.Double p = new Point2D.Double(this._stats.getImageX(), this._stats.getImageY());
            CoordinateConverter cc = this._mainImageDisplay.getCoordinateConverter();
            cc.imageToScreenCoords(p, false);
            this._imageZoom.zoom((int)p.x, (int)p.y, true);
        }
        this._updating = true;
        try {
            this._pickedObject();
        }
        finally {
            this._updating = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImageChangeEvent e = (ImageChangeEvent)ce;
        if (e.isNewImage()) {
            this._stats = null;
        }
    }

    @Override
    public void drawImageGraphics(BasicImageDisplay imgDisp, Graphics2D g) {
        if (this._stats == null) {
            return;
        }
        double rad = this._stats.getAngle() / 57.2958;
        double x = this._stats.getFwhmX();
        double y = this._stats.getFwhmY();
        double dxX = Math.cos(rad) * x / 2.0;
        double dyX = Math.sin(rad) * x / 2.0;
        double dxY = Math.cos(rad) * y / 2.0;
        double dyY = Math.sin(rad) * y / 2.0;
        double xc = this._stats.getImageX();
        double yc = this._stats.getImageY();
        CoordinateConverter cc = imgDisp.getCoordinateConverter();
        Point2D.Double px1 = new Point2D.Double(xc + dxX, yc + dyX);
        Point2D.Double px2 = new Point2D.Double(xc - dxX, yc - dyX);
        cc.imageToScreenCoords(px1, false);
        cc.imageToScreenCoords(px2, false);
        Point2D.Double py1 = new Point2D.Double(xc + dyY, yc - dxY);
        Point2D.Double py2 = new Point2D.Double(xc - dyY, yc + dxY);
        cc.imageToScreenCoords(py1, false);
        cc.imageToScreenCoords(py2, false);
        Line2D.Double lx = new Line2D.Double(px1, px2);
        Line2D.Double ly = new Line2D.Double(py1, py2);
        Stroke stroke = g.getStroke();
        Paint paint = g.getPaint();
        g.setStroke(this._bgStroke);
        g.setPaint(Color.black);
        g.draw(lx);
        g.draw(ly);
        g.setStroke(this._fgStroke);
        g.setPaint(Color.white);
        g.draw(lx);
        g.draw(ly);
        g.setStroke(stroke);
        g.setPaint(paint);
    }
}

