/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.Resources;

public class ImageDisplayStatusPanel
extends JPanel
implements MouseMotionListener {
    private static final I18N _I18N = I18N.getInstance(ImageDisplayStatusPanel.class);
    protected JTextField zoomTextField;
    protected JTextField imageCoordsTextField;
    protected JTextField pixelValueTextField;
    protected JTextField worldCoordsTextField;
    protected MainImageDisplay imageDisplay;
    protected static NumberFormat nf = NumberFormat.getInstance(Locale.US);

    public ImageDisplayStatusPanel() {
        Color bgColor = this.getBackground();
        this.setLayout(new BoxLayout(this, 0));
        JButton zoomIn = new JButton(Resources.getIcon((String)"ZoomIn24.gif"));
        zoomIn.setToolTipText(_I18N.getString("zoomIn"));
        zoomIn.setFocusPainted(false);
        zoomIn.setBorderPainted(false);
        zoomIn.setPreferredSize(new Dimension(26, 26));
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoom(true);
            }
        });
        this.add(zoomIn);
        JButton zoomOut = new JButton(Resources.getIcon((String)"ZoomOut24.gif"));
        zoomOut.setToolTipText(_I18N.getString("zoomOut"));
        zoomOut.setFocusPainted(false);
        zoomOut.setBorderPainted(false);
        zoomOut.setPreferredSize(new Dimension(26, 26));
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoom(false);
            }
        });
        this.add(zoomOut);
        JButton zoomFit = new JButton(Resources.getIcon((String)"AlignCenter24.gif"));
        zoomFit.setToolTipText(_I18N.getString("zoomFit"));
        zoomFit.setFocusPainted(false);
        zoomFit.setBorderPainted(false);
        zoomFit.setPreferredSize(new Dimension(26, 26));
        zoomFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoomFit();
            }
        });
        this.add(zoomFit);
        JButton zoomNormal = new JButton(Resources.getIcon((String)"Zoom24.gif"));
        zoomNormal.setToolTipText(_I18N.getString("zoomNormal"));
        zoomNormal.setFocusPainted(false);
        zoomNormal.setBorderPainted(false);
        zoomNormal.setPreferredSize(new Dimension(26, 26));
        zoomNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoomNormal();
            }
        });
        this.add(zoomNormal);
        this.zoomTextField = new JTextField(0);
        this.zoomTextField.setEditable(false);
        this.zoomTextField.setToolTipText(_I18N.getString("currentMagnification"));
        this.zoomTextField.setHorizontalAlignment(0);
        this.zoomTextField.setBackground(bgColor);
        this.zoomTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.zoomTextField.setText("1x");
        this.add(this.zoomTextField);
        this.imageCoordsTextField = new JTextField(6);
        this.imageCoordsTextField.setEditable(false);
        this.imageCoordsTextField.setToolTipText(_I18N.getString("imagePixelCoordsAtMousePos"));
        this.imageCoordsTextField.setHorizontalAlignment(0);
        this.imageCoordsTextField.setBackground(bgColor);
        this.imageCoordsTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.imageCoordsTextField);
        this.pixelValueTextField = new JTextField(6);
        this.pixelValueTextField.setEditable(false);
        this.pixelValueTextField.setToolTipText(_I18N.getString("imagePixelValueAtMousePos"));
        this.pixelValueTextField.setBackground(bgColor);
        this.pixelValueTextField.setHorizontalAlignment(0);
        this.pixelValueTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.pixelValueTextField);
        this.worldCoordsTextField = new JTextField(17);
        this.worldCoordsTextField.setEditable(false);
        this.worldCoordsTextField.setToolTipText(_I18N.getString("worldCoordsAtMousePos"));
        this.worldCoordsTextField.setHorizontalAlignment(0);
        this.worldCoordsTextField.setBackground(bgColor);
        this.worldCoordsTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.worldCoordsTextField);
    }

    public ImageDisplayStatusPanel(MainImageDisplay imageDisplay) {
        this();
        this.setImageDisplay(imageDisplay);
    }

    public void setImageDisplay(MainImageDisplay target) {
        this.imageDisplay = target;
        ((Component)((Object)this.imageDisplay)).addMouseMotionListener(this);
        this.imageDisplay.addChangeListener(ce -> {
            ImageChangeEvent e = (ImageChangeEvent)ce;
            if (e.isNewScale() || e.isNewImage()) {
                this.zoomTextField.setText(ImageDisplayMenuBar.getScaleLabel(this.imageDisplay.getScale()));
            }
        });
    }

    public MainImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    protected void zoom(boolean in) {
        float zoomFactor = this.imageDisplay.getScale();
        if (in) {
            if ((double)zoomFactor < 1.0) {
                int i = Math.round(1.0f / zoomFactor) - 1;
                zoomFactor = 1.0f / (float)i;
            } else {
                zoomFactor += 1.0f;
            }
        } else if ((double)zoomFactor <= 1.0) {
            int i = Math.round(1.0f / zoomFactor) + 1;
            zoomFactor = 1.0f / (float)i;
        } else {
            zoomFactor -= 1.0f;
        }
        if (zoomFactor < 0.05f || zoomFactor > 20.0f) {
            return;
        }
        this.imageDisplay.setScale(zoomFactor);
        this.imageDisplay.updateImage();
    }

    protected void zoomFit() {
        this.imageDisplay.scaleToFit();
        this.imageDisplay.updateImage();
    }

    protected void zoomNormal() {
        this.imageDisplay.setScale(1.0f);
        this.imageDisplay.updateImage();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.update(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.update(e);
    }

    protected void update(MouseEvent e) {
        Point2D.Double p;
        if (this.imageDisplay == null) {
            return;
        }
        try {
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToImageCoords(p, false);
            this.imageCoordsTextField.setText(nf.format(p.getX()) + ", " + nf.format(p.getY()));
            this.worldCoordsTextField.setText("");
            if (this.imageDisplay.isWCS()) {
                this.imageDisplay.getCoordinateConverter().imageToWorldCoords(p, false);
                double equinox = this.imageDisplay.getWCS().getEquinox();
                WorldCoords wcs = new WorldCoords(p.getX(), p.getY(), equinox);
                String[] ar = wcs.format(equinox);
                String equinoxStr = equinox == 2000.0 ? "J2000" : (equinox == 1950.0 ? "B1950" : Double.toString(equinox));
                MainImageDisplay.CoordSystemType coordSystem = this.imageDisplay.getCoordSystem();
                if (coordSystem.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
                    this.worldCoordsTextField.setText(ar[0] + ", " + ar[1] + " (" + equinoxStr + ")");
                } else if (coordSystem.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
                    this.worldCoordsTextField.setText(String.format("%+07.5g,%+03.7g (Galactic)", p.getX(), p.getY()));
                }
            }
        }
        catch (Exception equinox) {
            // empty catch block
        }
        try {
            this.pixelValueTextField.setText("");
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToUserCoords(p, false);
            float pixel = this.imageDisplay.getPixelValue(p, 0);
            ImageProcessor imageProcessor = this.imageDisplay.getImageProcessor();
            if (pixel == imageProcessor.getBlank()) {
                this.pixelValueTextField.setText(_I18N.getString("blank"));
            } else {
                this.pixelValueTextField.setText(String.valueOf(pixel));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        nf.setMaximumFractionDigits(1);
        nf.setGroupingUsed(false);
    }
}

