/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.interactor.Interactor;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jsky.image.graphics.RectangleGeometry;
import jsky.image.graphics.RoiFigure;

public class RoiRectangle
extends RoiFigure {
    public RoiRectangle(RectangularShape rect, Paint fill, Paint color, float lineWidth, Interactor interactor) {
        super(rect, fill, color, lineWidth, interactor);
    }

    public RoiRectangle(RectangularShape rect) {
        this(rect, (Paint)DEFAULT_FILL, (Paint)DEFAULT_LINE_COLOR, 2.0f, null);
    }

    public RoiRectangle(double x, double y, double width, double height) {
        this(new Rectangle2D.Double(x, y, width, height));
    }

    public void redraw() {
        RectangleGeometry rGeometry = this.getGeometry();
        Point2D center = rGeometry.getRotateCenter();
        double angle = rGeometry.getRotateAngle();
        AffineTransform at = new AffineTransform();
        at.setToRotation(angle, center.getX(), center.getY());
        RectangularShape shape = rGeometry.getRect();
        this.setShape(shape);
        super.transform(at);
    }

    public Point2D.Double getWidthInPoint2D() {
        Shape s = this.getShape();
        Point2D.Double width = null;
        if (s instanceof RectangularShape) {
            width = new Point2D.Double(((RectangularShape)s).getWidth(), 0.0);
        } else if (s instanceof Path2D) {
            PathIterator pathItr = s.getPathIterator(new AffineTransform());
            double[] coords = new double[6];
            pathItr.currentSegment(coords);
            double x0 = coords[0];
            double y0 = coords[1];
            pathItr.next();
            pathItr.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            width = new Point2D.Double(x1 - x0, y1 - y0);
        }
        return width;
    }

    public Point2D.Double getHeightInPoint2D() {
        Shape s = this.getShape();
        Point2D.Double height = null;
        if (s instanceof RectangularShape) {
            height = new Point2D.Double(0.0, ((RectangularShape)s).getHeight());
        } else if (s instanceof Path2D) {
            PathIterator pathItr = s.getPathIterator(new AffineTransform());
            double[] coords = new double[6];
            pathItr.currentSegment(coords);
            pathItr.next();
            pathItr.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            pathItr.next();
            pathItr.currentSegment(coords);
            double x2 = coords[0];
            double y2 = coords[1];
            height = new Point2D.Double(x2 - x1, y2 - y1);
        }
        return height;
    }
}

