/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.enumerations;

import alma.common.sensitivitycalculatorcore.capabilities.BasicAlmaArrayCapabilities;
import alma.common.sensitivitycalculatorcore.enumerations.BasicAntenna;

public enum BasicArray {
    ARRAY_12M("12m Array      ", BasicAntenna.ANTENNA_12M, true),
    ARRAY_7M("ACA 7m Array   ", BasicAntenna.ANTENNA_7M, true),
    ARRAY_TP("ACA Total Power", BasicAntenna.ANTENNA_12M, false);

    public final String name;
    public final BasicAntenna antenna;
    private boolean isInterferometery;
    public static final double ACA7M_BASELINE_M = 30.0;
    public static final double C = 2.99792458E8;
    public static final double GIGAHERTZ_TO_HERTZ = 1.0E9;

    private BasicArray(String name, BasicAntenna basicAntenna, boolean isInteferometery) {
        this.name = name;
        this.antenna = basicAntenna;
        this.isInterferometery = isInteferometery;
    }

    public int getNumberAntennas() {
        return BasicAlmaArrayCapabilities.getInstance().getNumAntennas(this);
    }

    public boolean isInterferometry() {
        return this.isInterferometery;
    }

    public String toString() {
        return this.name;
    }

    public static double syntheticBeamsize(double freqInGHZ, double baselineInM) {
        double f = freqInGHZ * 1.0E9;
        double arc = 2.99792458E8 / f;
        double angleInRad = arc / baselineInM;
        return angleInRad;
    }
}

