/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.enumerations;

import java.math.BigDecimal;
import java.util.ArrayList;

public enum BasicAntenna {
    ANTENNA_12M(12.0, "12m"),
    ANTENNA_7M(7.0, "7m");

    public static double BEAMSIZE_FACTOR;
    public static String BEAMSIZE_TIP_STRING;
    public static String SYNBEAMSIZE_TIP_STRING;
    public static final double RAD_TO_ARCSEC = 206264.80624709636;
    public static final double C = 2.99792458E8;
    public static final double GIGAHERTZ_TO_HERTZ = 1.0E9;
    private double diameter;
    private String label;
    private static String[] labels;

    private BasicAntenna(double diameter, String label) {
        this.diameter = diameter;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public double getApertureArea() {
        return this.diameter * this.diameter * Math.PI / 4.0;
    }

    public static String[] getLabels() {
        if (labels == null) {
            ArrayList<String> v = new ArrayList<String>();
            for (BasicAntenna a : BasicAntenna.values()) {
                v.add(a.label);
            }
            labels = v.toArray(new String[v.size()]);
        }
        return labels;
    }

    public static BasicAntenna getValue(String label) {
        for (BasicAntenna a : BasicAntenna.values()) {
            if (!a.label.equals(label)) continue;
            return a;
        }
        return null;
    }

    public double getBeamSize(double freqInGHZ) {
        double f = freqInGHZ * 1.0E9;
        double wavelengthInM = 2.99792458E8 / f;
        double v = BEAMSIZE_FACTOR * wavelengthInM / this.getDiameter();
        double beamsize = v * 206264.80624709636;
        return beamsize;
    }

    public String formatBeamSize(double f) {
        return this.formatBeamSize(this.getBeamSize(f));
    }

    public static String formatBeamSize(Double bsInArcsec) {
        double v = 0.0;
        if (bsInArcsec > 0.0 && bsInArcsec < Double.POSITIVE_INFINITY) {
            BigDecimal bd = new BigDecimal(String.valueOf(bsInArcsec));
            v = bd.setScale(3, 4).doubleValue();
        }
        return String.format("%4.3f %s", v, "arcsec");
    }

    static {
        BEAMSIZE_FACTOR = 1.13;
        BEAMSIZE_TIP_STRING = String.format("%.1f * &lambda; / D", BEAMSIZE_FACTOR);
        SYNBEAMSIZE_TIP_STRING = String.format("%.1f * &lambda; / L", BEAMSIZE_FACTOR);
    }
}

