/*
 * Decompiled with CFR 0.152.
 */
package diva.util.xml;

import diva.util.xml.AbstractXmlBuilder;
import diva.util.xml.XmlBuilder;
import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import diva.util.xml.XmlReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;

public class CompositeBuilder
extends AbstractXmlBuilder {
    public static final String PUBLIC_ID = "-//UC Berkeley//DTD builder 1//EN";
    public static final String DTD_URL = "http://www.gigascale.org/diva/dtd/builder.dtd";
    public static final String DTD_1 = "<!ELEMENT builderDecls (builder*)><!ATTLIST builderDecls ref CDATA #IMPLIED><!ATTLIST builder name CDATA #REQUIRED class CDATA #REQUIRED builder CDATA #REQUIRED>";
    public static final String CLASS_TAG = "class";
    public static final String TAG_TAG = "tag";
    public static final String BUILDER_TAG = "builder";
    public static final String BUILDER_DECLS_TAG = "builderDecls";
    private HashMap _builders = new HashMap();

    public void addBuilderDecls(Reader in) throws Exception {
        XmlDocument doc = new XmlDocument();
        doc.setDTDPublicID(PUBLIC_ID);
        doc.setDTD(DTD_1);
        XmlReader reader = new XmlReader();
        reader.parse(doc, in);
        if (reader.getErrorCount() > 0) {
            throw new Exception("errors encountered during parsing");
        }
        Iterator i = doc.getRoot().elements();
        while (i.hasNext()) {
            XmlElement builder = (XmlElement)i.next();
            String[] val = new String[]{builder.getAttribute(CLASS_TAG), builder.getAttribute(BUILDER_TAG)};
            this._builders.put(builder.getAttribute(TAG_TAG), val);
            this._builders.put(builder.getAttribute(CLASS_TAG), val);
            this.debug("Adding: " + builder.getAttribute(TAG_TAG) + "=>" + builder.getAttribute(BUILDER_TAG));
        }
    }

    private void debug(String out) {
        System.out.println(out);
    }

    public Object build(XmlElement elt, String type) throws Exception {
        String[] val = (String[])this._builders.get(type);
        if (val == null) {
            if (this.getDelegate() == null) {
                String err = "Unknown type: " + type;
                throw new Exception(err);
            }
            return this.getDelegate().build(elt, type);
        }
        XmlBuilder builder = (XmlBuilder)Class.forName(val[1]).newInstance();
        builder.setDelegate(this);
        return builder.build(elt, val[0]);
    }

    public XmlElement generate(Object in) throws Exception {
        String[] val = (String[])this._builders.get(in.getClass().getName());
        if (val == null) {
            if (this.getDelegate() == null) {
                String err = "Unknown type: " + in.getClass().getName();
                throw new Exception(err);
            }
            return this.getDelegate().generate(in);
        }
        XmlBuilder builder = (XmlBuilder)Class.forName(val[1]).newInstance();
        builder.setDelegate(this);
        return builder.generate(in);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("java CompositeBuilder <builderDeclsURI> <fileURI>");
            System.exit(1);
        } else {
            XmlDocument doc = new XmlDocument();
            XmlReader reader = new XmlReader();
            CompositeBuilder builder = new CompositeBuilder();
            builder.addBuilderDecls(new FileReader(args[0]));
            reader.parse(doc, new FileReader(args[1]));
            System.out.println("out = " + builder.build(doc.getRoot(), doc.getRoot().getType()));
        }
    }
}

