/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PaintedGraphic;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class AbstractPaintedGraphic
implements PaintedGraphic {
    public Stroke stroke;
    public Shape shape;
    public Paint strokePaint;
    private static BasicStroke[] _strokes = new BasicStroke[16];

    public abstract float getLineWidth();

    public Rectangle2D getBounds() {
        if (this.stroke == null) {
            return this.shape.getBounds2D();
        }
        if (this.stroke instanceof BasicStroke) {
            Rectangle2D rect = this.shape.getBounds2D();
            int width = (int)((BasicStroke)this.stroke).getLineWidth() + 2;
            return new Rectangle2D.Double(rect.getX() - (double)width, rect.getY() - (double)width, rect.getWidth() + (double)width + (double)width, rect.getHeight() + (double)width + (double)width);
        }
        Rectangle2D rect = this.stroke.createStrokedShape(this.shape).getBounds2D();
        return new Rectangle2D.Double(rect.getX() - 1.0, rect.getY() - 1.0, rect.getWidth() + 2.0, rect.getHeight() + 2.0);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public static BasicStroke getStroke(int width) {
        if (width < _strokes.length) {
            if (_strokes[width] == null) {
                AbstractPaintedGraphic._strokes[width] = new BasicStroke(width);
            }
            return _strokes[width];
        }
        return new BasicStroke(width);
    }

    public static BasicStroke getStroke(float floatwidth) {
        int width = Math.round(floatwidth);
        if ((float)width == floatwidth) {
            return AbstractPaintedGraphic.getStroke(width);
        }
        return new BasicStroke(floatwidth);
    }

    public abstract boolean hit(Rectangle2D var1);

    public abstract void setLineWidth(float var1);
}

