/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.AbstractDocument;
import diva.gui.Application;
import diva.gui.MultipageModel;
import diva.gui.MultipageParser;
import diva.gui.MultipageWriter;
import diva.util.ModelParser;
import diva.util.ModelWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;

public abstract class MultipageDocument
extends AbstractDocument {
    private MultipageModel _model = new MultipageModel();
    MultipageWriter _writer;
    MultipageParser _parser;
    ModelWriter _modelWriter;
    ModelParser _modelParser;
    String _title = "Untitled";

    public MultipageDocument(String title, Application a, ModelParser parser, ModelWriter writer) {
        super(a);
        this._title = title;
        this._modelWriter = writer;
        this._modelParser = parser;
        this._writer = new MultipageWriter(writer);
        this._parser = new MultipageParser(parser);
    }

    public void close() throws Exception {
        System.out.println("Close " + this._title);
    }

    public String getTitle() {
        return this._title;
    }

    public MultipageModel getMultipageModel() {
        return this._model;
    }

    public void open() throws Exception {
        if (this.getFile() == null) {
            throw new IllegalStateException("MultipageDocument " + this.getTitle() + " has no current file");
        }
        String filename = this.getFile().getName();
        System.out.println("Parsing " + filename);
        this._parser.parse(new FileReader(filename), this.getMultipageModel());
    }

    public void save() throws Exception {
        if (this.getFile() == null) {
            throw new IllegalStateException("MultipageDocument " + this.getTitle() + " has no current file");
        }
        this.saveAs(this.getFile());
    }

    public void saveAs(File file) throws Exception {
        String filename;
        this._title = filename = file.getName();
        FileWriter out = new FileWriter(file);
        this._writer.write(this.getMultipageModel(), out);
        out.flush();
        out.close();
    }

    public void saveAs(URL url) {
        throw new UnsupportedOperationException("SketchDocument " + this.getTitle() + ": save to URL not supported");
    }
}

