/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.toolbox;

import diva.canvas.Figure;
import diva.graph.GraphController;
import diva.graph.NodeRenderer;
import java.util.Hashtable;

public class TypedNodeRenderer
implements NodeRenderer {
    private GraphController _controller = null;
    private NodeRenderer _defaultRenderer = null;
    private Hashtable _typedRenderers = null;

    public TypedNodeRenderer(GraphController controller, NodeRenderer defaultRenderer) {
        this._controller = controller;
        this._defaultRenderer = defaultRenderer;
        this._typedRenderers = new Hashtable();
    }

    public void addTypedRenderer(Class c, NodeRenderer r) {
        this._typedRenderers.put(c, r);
    }

    public void removeTypedRenderer(Class c) {
        this._typedRenderers.remove(c);
    }

    public Figure render(Object node) {
        try {
            Object o = this._controller.getGraphModel().getSemanticObject(node);
            NodeRenderer r = (NodeRenderer)this._typedRenderers.get(o.getClass());
            return r.render(node);
        }
        catch (Exception ex) {
            return this._defaultRenderer.render(node);
        }
    }
}

