/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.GraphModel;
import diva.graph.GraphUtilities;
import diva.graph.layout.LayoutTarget;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public final class LayoutUtilities {
    public static final void place(LayoutTarget target, Object node, double x, double y) {
        Object edge;
        GraphModel model = target.getGraphModel();
        LayoutUtilities.placeNoReroute(target, node, x, y);
        Iterator i = model.inEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            if (!target.isEdgeVisible(edge)) continue;
            target.route(edge);
        }
        i = model.outEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            if (!target.isEdgeVisible(edge)) continue;
            target.route(edge);
        }
    }

    public static final void placeNoReroute(LayoutTarget target, Object node, double x, double y) {
        Rectangle2D bounds = target.getBounds(node);
        target.translate(node, x - bounds.getWidth() / 2.0 - bounds.getX(), y - bounds.getHeight() / 2.0 - bounds.getY());
    }

    public static final boolean checkConsistency(Object composite, GraphModel model) {
        if (!GraphUtilities.checkConsistency(composite, model)) {
            return false;
        }
        return LayoutUtilities.checkCommon(composite, model);
    }

    public static final boolean checkContainment(Object composite, GraphModel model) {
        if (!GraphUtilities.checkContainment(composite, model)) {
            return false;
        }
        return LayoutUtilities.checkCommon(composite, model);
    }

    private static final boolean checkCommon(Object composite, GraphModel model) {
        return true;
    }

    public static final void routeVisibleEdges(Object composite, LayoutTarget target) {
        Iterator i = GraphUtilities.totallyContainedEdges(composite, target.getGraphModel());
        while (i.hasNext()) {
            Object edge = i.next();
            if (!target.isEdgeVisible(edge)) continue;
            target.route(edge);
        }
    }
}

