/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.basic;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.NodeRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class BasicNodeRenderer
implements NodeRenderer {
    private GraphController _controller;
    private Shape _nodeShape = null;
    private Shape _compositeShape = null;
    private double _compositeScale = 0.0;
    private Paint _nodeFill = null;
    private Paint _compositeFill = null;

    public BasicNodeRenderer(GraphController controller) {
        this(controller, new Rectangle2D.Double(0.0, 0.0, 40.0, 40.0), new Rectangle2D.Double(0.0, 0.0, 600.0, 600.0), Color.orange, Color.red, 0.3);
    }

    public BasicNodeRenderer(GraphController controller, Shape nodeShape, Shape compositeShape, Paint nodeFill, Paint compositeFill, double compositeScale) {
        this._controller = controller;
        this.setNodeShape(nodeShape);
        this.setNodeFill(nodeFill);
        this.setCompositeShape(compositeShape);
        this.setCompositeFill(compositeFill);
        this.setCompositeScale(compositeScale);
    }

    public Paint getCompositeFill() {
        return this._compositeFill;
    }

    public double getCompositeScale() {
        return this._compositeScale;
    }

    public Shape getCompositeShape() {
        return this._compositeShape;
    }

    public GraphController getGraphController() {
        return this._controller;
    }

    public Paint getNodeFill() {
        return this._nodeFill;
    }

    public Shape getNodeShape() {
        return this._nodeShape;
    }

    public Figure render(Object node) {
        Shape shape;
        GraphModel model = this._controller.getGraphModel();
        Shape shape2 = shape = model.isComposite(node) ? this._compositeShape : this._nodeShape;
        if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            shape = (Shape)r.clone();
        } else {
            shape = new GeneralPath(shape);
        }
        Paint fill = model.isComposite(node) ? this._compositeFill : this._nodeFill;
        BasicFigure bf = new BasicFigure(shape);
        bf.setFillPaint(fill);
        if (model.isComposite(node)) {
            CompositeFigure rep = new CompositeFigure(bf);
            double scale = this.getCompositeScale();
            rep.getTransformContext().getTransform().scale(scale, scale);
            return rep;
        }
        bf.setToolTipText(bf.toString());
        return bf;
    }

    public void setCompositeFill(Paint p) {
        this._compositeFill = p;
    }

    public void setCompositeScale(double scale) {
        if (scale <= 0.0 || scale > 1.0) {
            String err = "Scale must be between > 0 and <= 1.";
            throw new IllegalArgumentException(err);
        }
        this._compositeScale = scale;
    }

    public void setCompositeShape(Shape s) {
        this._compositeShape = s;
    }

    public void setNodeFill(Paint p) {
        this._nodeFill = p;
    }

    public void setNodeShape(Shape s) {
        this._nodeShape = s;
    }
}

