/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.basic;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.GraphicsPane;
import diva.canvas.ZList;
import diva.canvas.connector.Connector;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.layout.LayoutTarget;
import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.ProxyIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class BasicLayoutTarget
implements LayoutTarget {
    private GraphController _controller;
    private double _layoutPercentage = 0.8;

    public BasicLayoutTarget(GraphController controller) {
        this._controller = controller;
    }

    public Rectangle2D getBounds(Object node) {
        Figure f = this._controller.getFigure(node);
        return f.getBounds();
    }

    public GraphController getController() {
        return this._controller;
    }

    public GraphModel getGraphModel() {
        return this._controller.getGraphModel();
    }

    public double getLayoutPercentage() {
        return this._layoutPercentage;
    }

    protected GraphicsPane getGraphicsPane() {
        return this._controller.getGraphPane();
    }

    protected Object getRootGraph() {
        return this._controller.getGraphModel().getRoot();
    }

    public Rectangle2D getViewport(Object composite) {
        CompositeFigure cf;
        GraphModel model = this._controller.getGraphModel();
        if (composite == this.getRootGraph()) {
            Point2D p = this.getGraphicsPane().getSize();
            double borderPercentage = (1.0 - this.getLayoutPercentage()) / 2.0;
            double x = borderPercentage * p.getX();
            double y = borderPercentage * p.getY();
            double w = this.getLayoutPercentage() * p.getX();
            double h = this.getLayoutPercentage() * p.getY();
            return new Rectangle2D.Double(x, y, w, h);
        }
        if (model.isComposite(composite) && (cf = (CompositeFigure)this._controller.getFigure(composite)) != null) {
            return cf.getShape().getBounds2D();
        }
        String err = "Unknown graph.  Cannot determine viewport.";
        throw new IllegalArgumentException(err);
    }

    public Object getVisualObject(Object object) {
        return this._controller.getFigure(object);
    }

    public boolean isNodeVisible(Object node) {
        Figure nf = this._controller.getFigure(node);
        return nf != null && nf.isVisible() && nf.getParent() != null;
    }

    public boolean isEdgeVisible(Object edge) {
        Connector ef = (Connector)this._controller.getFigure(edge);
        return ef != null && ef.isVisible() && ef.getParent() != null;
    }

    public Iterator intersectingNodes(Rectangle2D r) {
        final GraphModel model = this._controller.getGraphModel();
        ZList zlist = this.getGraphicsPane().getForegroundLayer().getFigures();
        Iterator i = zlist.getIntersectedFigures(r).figuresFromFront();
        FilteredIterator j = new FilteredIterator(i, new Filter(){

            public boolean accept(Object o) {
                Figure f = (Figure)o;
                return model.isNode(f.getUserObject());
            }
        });
        return new ProxyIterator(j){

            public Object next() {
                Figure nf = (Figure)super.next();
                return nf.getUserObject();
            }
        };
    }

    public Iterator intersectingEdges(Rectangle2D r) {
        ZList zlist = this.getGraphicsPane().getForegroundLayer().getFigures();
        Iterator i = zlist.getIntersectedFigures(r).figuresFromFront();
        FilteredIterator j = new FilteredIterator(i, new Filter(){

            public boolean accept(Object o) {
                return o instanceof Connector;
            }
        });
        return new ProxyIterator(j){

            public Object next() {
                Connector ef = (Connector)super.next();
                return ef.getUserObject();
            }
        };
    }

    public void route(Object edge) {
        Connector ef = (Connector)this._controller.getFigure(edge);
        ef.reroute();
    }

    public void setLayoutPercentage(double d) {
        if (d <= 0.0 || d > 1.0) {
            String err = "Layout percentage must be between 0 and 1";
            throw new IllegalArgumentException(err);
        }
        this._layoutPercentage = d;
    }

    public void translate(Object node, double dx, double dy) {
        Figure f = this._controller.getFigure(node);
        f.translate(dx, dy);
    }
}

