/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.canvas.connector.Connector;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphUtilities;
import java.util.HashSet;
import java.util.Iterator;

public class NodeDragInteractor
extends DragInteractor {
    private GraphController _controller;

    public NodeDragInteractor(GraphController controller) {
        this._controller = controller;
    }

    public GraphController getController() {
        return this._controller;
    }

    public void translate(LayerEvent e, double x, double y) {
        GraphModel model = this._controller.getGraphModel();
        Iterator i = this.targets();
        HashSet edgeSet = new HashSet();
        while (i.hasNext()) {
            Figure t = (Figure)i.next();
            if (model.isEdge(t.getUserObject())) continue;
            t.translate(x, y);
        }
        edgeSet.addAll(GraphUtilities.edgeSet(model.getRoot(), model));
        for (Object edge : edgeSet) {
            Connector c = (Connector)this._controller.getFigure(edge);
            if (c == null) continue;
            c.reroute();
        }
    }
}

