/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.util.java2d.PaintedList;
import diva.util.java2d.PaintedObject;
import diva.util.java2d.ShapeUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PaintedFigure
extends AbstractFigure {
    private Composite _composite = AlphaComposite.SrcOver;
    private AffineTransform _transform = new AffineTransform();
    private PaintedList _paintedList;

    public PaintedFigure() {
        this._paintedList = new PaintedList();
    }

    public PaintedFigure(PaintedList objects) {
        this._paintedList = objects;
    }

    public void add(PaintedObject po) {
        this._paintedList.add(po);
        this.repaint();
    }

    public PaintedList getPaintedList() {
        return this._paintedList;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = (Rectangle2D)ShapeUtilities.transformModify(this._paintedList.getBounds(), this._transform);
        return bounds;
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this._transform.getTranslateX(), this._transform.getTranslateY());
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public Composite getComposite() {
        return this._composite;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._composite != null) {
            g.setComposite(this._composite);
        }
        AffineTransform savedTransform = g.getTransform();
        g.transform(this._transform);
        this._paintedList.paint(g);
        g.setTransform(savedTransform);
    }

    public void setComposite(Composite c) {
        this._composite = c;
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._transform.preConcatenate(at);
        this.repaint();
    }
}

