/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.toolbox.LabelFigure;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LabelWrapper
extends AbstractFigure {
    private Figure _child = null;
    private LabelFigure _label = null;
    private int _anchor = 0;

    public LabelWrapper(Figure f, String label) {
        this._child = f;
        f.setParent(this);
        this._label = new LabelFigure(label);
        Point2D pt = CanvasUtilities.getLocation(this._child.getBounds(), this._anchor);
        this._label.translateTo(pt);
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = this._child.getBounds();
        Rectangle2D.union(bounds, this._label.getBounds(), bounds);
        return bounds;
    }

    public Figure getChild() {
        return this._child;
    }

    public LabelFigure getLabel() {
        return this._label;
    }

    public Shape getShape() {
        return this._child.getShape();
    }

    public boolean hit(Rectangle2D r) {
        return this._child.hit(r) || this._label.hit(r);
    }

    public void paint(Graphics2D g) {
        if (this._child != null && this.isVisible()) {
            this._child.paint(g);
            this._label.paint(g);
        }
    }

    public void setAnchor(int anchor) {
        this._anchor = anchor;
        Point2D pt = CanvasUtilities.getLocation(this._child.getBounds(), anchor);
        this.repaint();
        this._label.translateTo(pt);
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._child.transform(at);
        Point2D pt = CanvasUtilities.getLocation(this._child.getBounds(), this._anchor);
        this._label.translateTo(pt);
        this.repaint();
    }
}

