/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.CanvasLayer;
import diva.canvas.VisibleComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GridLayer
extends CanvasLayer
implements VisibleComponent {
    private Paint _gridPaint = Color.lightGray;
    private Stroke _gridStroke = new BasicStroke();
    private Point2D _origin = new Point2D.Double(0.0, 0.0);
    private Point2D _size = new Point2D.Double(10.0, 10.0);
    private Paint _vertexPaint;
    private Shape _vertexShape;
    private boolean _visible = true;

    public GridLayer() {
    }

    public GridLayer(Stroke s, Paint p) {
        this.setGridStroke(s);
        this.setGridPaint(p);
    }

    public GridLayer(Shape s, Paint p) {
        this.setGridPaint(null);
        this.setVertexShape(s);
        this.setVertexPaint(p);
    }

    public Stroke getGridStroke() {
        return this._gridStroke;
    }

    public Paint getGridPaint() {
        return this._gridPaint;
    }

    public Shape getVertexShape() {
        return this._vertexShape;
    }

    public Paint getVertexPaint() {
        return this._vertexPaint;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void paint(Graphics2D g) {
        Point2D paneSize = this.getCanvasPane().getSize();
        if (!this.isVisible()) {
            return;
        }
        double originX = this._origin.getX();
        double originY = this._origin.getY();
        double sizeX = this._size.getX();
        double sizeY = this._size.getY();
        double paneX = paneSize.getX();
        double paneY = paneSize.getY();
        if (this._gridPaint != null) {
            g.setPaint(this._gridPaint);
            for (double x = originX; x < paneX; x += sizeX) {
                g.drawLine((int)x, (int)originY, (int)x, (int)paneY);
                for (double y = originY; y < paneY; y += sizeY) {
                    g.drawLine((int)originX, (int)y, (int)paneX, (int)y);
                }
            }
        }
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (!this.isVisible()) {
            return;
        }
        this.paint(g);
    }

    public void setGridStroke(Stroke s) {
        if (s == null) {
            throw new NullPointerException("Cannot set stroke to null");
        }
        this._gridStroke = s;
        this.repaint();
    }

    public void setGridPaint(Paint p) {
        this._gridPaint = p;
        this.repaint();
    }

    public void setVertexShape(Shape s) {
        if (s == null) {
            throw new NullPointerException("Cannot set shape to null");
        }
        this._vertexShape = s;
        this.repaint();
    }

    public void setVertexPaint(Paint p) {
        this._vertexPaint = p;
        if (this._vertexPaint != null && this._vertexShape == null) {
            double r = Math.min(this._size.getX(), this._size.getY());
            this._vertexShape = new Ellipse2D.Double(-r, -r, 2.0 * r, 2.0 * r);
        }
        this.repaint();
    }

    public void setVisible(boolean flag) {
        this._visible = flag;
    }
}

