/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.connector.CenterSite;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.BasicGrabHandleFactory;
import diva.canvas.interactor.BoundsGeometry;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.GrabHandleFactory;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.Manipulator;
import diva.canvas.interactor.MoveHandle;
import java.util.Iterator;

public class BoundsManipulator
extends Manipulator {
    private BoundsGeometry _geometry;
    private Interactor _dragInteractor = null;

    public BoundsManipulator() {
        this(new BasicGrabHandleFactory());
    }

    public BoundsManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new Resizer());
    }

    public Interactor getDragInteractor() {
        return this._dragInteractor;
    }

    public BoundsGeometry getGeometry() {
        return this._geometry;
    }

    public void mouseReleased(LayerEvent e) {
    }

    public FigureDecorator newInstance(Figure f) {
        BoundsManipulator m = new BoundsManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        m.setDragInteractor(this._dragInteractor);
        return m;
    }

    public void refresh() {
        if (this._geometry != null) {
            this._geometry.setBounds(this.getChild().getBounds());
        }
    }

    public void setChild(Figure child) {
        super.setChild(child);
        this.clearGrabHandles();
        if (child != null) {
            this._geometry = new BoundsGeometry(this, this.getChild().getBounds());
            Iterator i = this._geometry.sites();
            GrabHandle g = null;
            while (i.hasNext()) {
                Site site = (Site)i.next();
                g = this.getGrabHandleFactory().createGrabHandle(site);
                g.setParent(this);
                g.setInteractor(this.getHandleInteractor());
                this.addGrabHandle(g);
            }
            if (this._dragInteractor != null) {
                CenterSite center = new CenterSite(this.getChild());
                MoveHandle mover = new MoveHandle(center);
                mover.setParent(this);
                mover.setInteractor(this._dragInteractor);
                this.addGrabHandle(mover);
            }
            this.relocateGrabHandles();
            this._geometry.setMinimumSize(4.0f * g.getSize());
        }
    }

    public void setDragInteractor(Interactor dragger) {
        this._dragInteractor = dragger;
    }

    private class Resizer
    extends DragInteractor {
        private Resizer() {
        }

        public void mouseReleased(LayerEvent e) {
            super.mouseReleased(e);
            BoundsManipulator.this.mouseReleased(e);
        }

        public void translate(LayerEvent e, double x, double y) {
            GrabHandle g = (GrabHandle)e.getFigureSource();
            g.translate(x, y);
            BoundsManipulator parent = (BoundsManipulator)g.getParent();
            BoundsGeometry geometry = parent.getGeometry();
            parent.getChild().transform(CanvasUtilities.computeTransform(parent.getChild().getBounds(), geometry.getBounds()));
        }
    }
}

