/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.interactor.SelectionRenderer;
import diva.canvas.toolbox.BasicHighlighter;
import java.util.Hashtable;

public class BasicSelectionRenderer
implements SelectionRenderer {
    private Hashtable _decorators = new Hashtable();
    private FigureDecorator _prototypeDecorator;

    public BasicSelectionRenderer() {
        this._prototypeDecorator = new BasicHighlighter();
    }

    public BasicSelectionRenderer(FigureDecorator d) {
        this._prototypeDecorator = d;
    }

    public FigureDecorator getDecorator() {
        return this._prototypeDecorator;
    }

    public boolean isRenderedSelected(Figure figure) {
        return this._decorators.containsKey(figure);
    }

    public void renderDeselected(Figure figure) {
        if (!this._decorators.containsKey(figure)) {
            return;
        }
        FigureDecorator d = (FigureDecorator)this._decorators.get(figure);
        if (d.getParent() != null) {
            figure.repaint();
            ((FigureContainer)d.getParent()).undecorate(d);
        }
        this._decorators.remove(figure);
    }

    public void renderSelected(Figure figure) {
        if (this._decorators.containsKey(figure)) {
            ((Figure)this._decorators.get(figure)).repaint();
        } else {
            FigureContainer parent = (FigureContainer)figure.getParent();
            if (parent != null) {
                FigureDecorator d = this._prototypeDecorator.newInstance(figure);
                parent.decorate(figure, d);
                this._decorators.put(figure, d);
            }
        }
    }

    public void setDecorator(FigureDecorator d) {
        this._prototypeDecorator = d;
    }
}

