/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.event;

import diva.canvas.event.MouseFilter;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class ExtendedMouseFilter
extends MouseFilter {
    public static final MouseFilter defaultFilter = new ExtendedMouseFilter(1);
    public static final MouseFilter selectionFilter = new ExtendedMouseFilter(1);
    public static final MouseFilter alternateSelectionFilter = new ExtendedMouseFilter(1, 64);
    private int _button = 1;
    private int _modifierMask;
    private int _modifierFlags;
    private int _pressNumber;

    public ExtendedMouseFilter(int button) {
        this(button, 0);
    }

    public ExtendedMouseFilter(int button, int extendedModifiers) {
        this(button, extendedModifiers, 9152);
    }

    public ExtendedMouseFilter(int button, int extendedModifiers, int mask) {
        this(button, extendedModifiers, mask, -1);
    }

    public ExtendedMouseFilter(int button, int extendedModifiers, int mask, int pressNumber) {
        super(0);
        this._button = button;
        this._modifierFlags = extendedModifiers;
        this._modifierMask = mask;
        this._pressNumber = pressNumber;
    }

    public boolean accept(MouseEvent event) {
        if (this._pressNumber != -1 && event.getClickCount() != this._pressNumber) {
            return false;
        }
        int m = event.getModifiersEx();
        boolean val = event.getButton() == this._button && this._modifierFlags == (m & this._modifierMask);
        return val;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().toString() + "; Button " + this._button + "; Modifiers " + InputEvent.getModifiersExText(this._modifierFlags) + "; Modifier mask " + InputEvent.getModifiersExText(this._modifierMask) + "; Press Number " + this._pressNumber);
        return result.toString();
    }
}

