/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;

public class BoundsSite
extends AbstractSite {
    private int _id;
    private int _side;
    private double _offset;
    private Figure _parentFigure;

    public BoundsSite(Figure figure, int id, int side, double offset) {
        this._parentFigure = figure;
        this._id = id;
        this._side = side;
        this._offset = offset;
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._id;
    }

    public double getNormal() {
        switch (this._side) {
            case 1: {
                return -1.5707963267948966;
            }
            case 5: {
                return 1.5707963267948966;
            }
            case 3: {
                return 0.0;
            }
            case 7: {
                return Math.PI;
            }
        }
        return 0.0;
    }

    public double getOffset() {
        return this._offset;
    }

    public int getSide() {
        return this._side;
    }

    public double getX() {
        Rectangle bounds = this._parentFigure.getShape().getBounds();
        double x = 0.0;
        switch (this._side) {
            case 1: 
            case 5: {
                x = ((RectangularShape)bounds).getX() + this._offset / 100.0 * ((RectangularShape)bounds).getWidth();
                break;
            }
            case 3: {
                x = ((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth();
                break;
            }
            case 7: {
                x = ((RectangularShape)bounds).getX();
            }
        }
        return x;
    }

    public double getY() {
        Rectangle bounds = this._parentFigure.getShape().getBounds();
        double y = 0.0;
        switch (this._side) {
            case 3: 
            case 7: {
                y = ((RectangularShape)bounds).getY() + this._offset / 100.0 * ((RectangularShape)bounds).getHeight();
                break;
            }
            case 5: {
                y = ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight();
                break;
            }
            case 1: {
                y = ((RectangularShape)bounds).getY();
            }
        }
        return y;
    }

    public String toString() {
        return "BoundsSite[" + this.getX() + "," + this.getY() + "," + this.getNormal() + "]";
    }
}

