/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasUtilities;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ManhattanConnector;
import diva.canvas.connector.ManhattanRouter;
import diva.util.java2d.Polyline2D;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class BasicManhattanRouter
implements ManhattanRouter {
    private double TOL = 0.1;
    private double MINDIST = 7.0;

    public void rerouteHead(Connector c, Shape s) {
        this.reroute(c, s);
    }

    public void rerouteTail(Connector c, Shape s) {
        this.reroute(c, s);
    }

    public void reroute(Connector c, Shape s) {
        this.route(c);
    }

    public Shape route(Connector c) {
        return this.routeManhattan((ManhattanConnector)c);
    }

    public Polyline2D routeManhattan(ManhattanConnector c) {
        Point2D headPt;
        Point2D tailPt;
        TransformContext currentContext = c.getTransformContext();
        Site headSite = c.getHeadSite();
        Site tailSite = c.getTailSite();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        double xDiff = headPt.getX() - tailPt.getX();
        double yDiff = headPt.getY() - tailPt.getY();
        int headDir = CanvasUtilities.reverseDirection(this.getManhattanDirection(xDiff, yDiff));
        headSite.setNormal(CanvasUtilities.getNormal(headDir));
        headPt = currentContext != null ? headSite.getPoint(currentContext) : headSite.getPoint();
        int tailDir = this.getManhattanDirection(xDiff, yDiff);
        tailSite.setNormal(CanvasUtilities.getNormal(tailDir));
        tailPt = currentContext != null ? tailSite.getPoint(currentContext) : tailSite.getPoint();
        headDir = CanvasUtilities.getDirection(headSite.getNormal());
        tailDir = CanvasUtilities.getDirection(tailSite.getNormal());
        double headAngle = CanvasUtilities.getNormal(headDir);
        double tailAngle = CanvasUtilities.getNormal(tailDir);
        if (c.getHeadEnd() != null) {
            c.getHeadEnd().setNormal(headAngle);
            c.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
            c.getHeadEnd().getConnection(headPt);
        }
        if (c.getTailEnd() != null) {
            c.getTailEnd().setNormal(tailAngle);
            c.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
            c.getTailEnd().getConnection(tailPt);
        }
        Polyline2D route = this._route(headPt, headDir, tailPt, tailDir);
        return route;
    }

    private Polyline2D _route(Point2D head, int headDir, Point2D tail, int tailDir) {
        double pos;
        int dir;
        Point2D point;
        double xDiff = head.getX() - tail.getX();
        double yDiff = head.getY() - tail.getY();
        if (xDiff * xDiff < this.TOL * this.TOL && yDiff * yDiff < this.TOL * this.TOL) {
            Polyline2D.Double route = new Polyline2D.Double();
            ((Polyline2D)route).moveTo(tail.getX(), tail.getY());
            return route;
        }
        if (headDir == 7) {
            if (xDiff > 0.0 && yDiff * yDiff < this.TOL && tailDir == 3) {
                point = tail;
                dir = tailDir;
            } else {
                if (xDiff < 0.0) {
                    point = new Point2D.Double(head.getX() - this.MINDIST, head.getY());
                } else if (yDiff > 0.0 && tailDir == 5 || yDiff < 0.0 && tailDir == 1) {
                    point = new Point2D.Double(tail.getX(), head.getY());
                } else if (headDir == tailDir) {
                    pos = Math.min(head.getX(), tail.getX()) - this.MINDIST;
                    point = new Point2D.Double(pos, head.getY());
                } else {
                    point = new Point2D.Double(head.getX() - xDiff / 2.0, head.getY());
                }
                dir = yDiff > 0.0 ? 1 : 5;
            }
        } else if (headDir == 3) {
            if (xDiff < 0.0 && yDiff * yDiff < this.TOL && tailDir == 7) {
                point = tail;
                dir = tailDir;
            } else {
                if (xDiff > 0.0) {
                    point = new Point2D.Double(head.getX() + this.MINDIST, head.getY());
                } else if (yDiff > 0.0 && tailDir == 5 || yDiff < 0.0 && tailDir == 1) {
                    point = new Point2D.Double(tail.getX(), head.getY());
                } else if (headDir == tailDir) {
                    pos = Math.max(head.getX(), tail.getX()) + this.MINDIST;
                    point = new Point2D.Double(pos, head.getY());
                } else {
                    point = new Point2D.Double(head.getX() - xDiff / 2.0, head.getY());
                }
                dir = yDiff > 0.0 ? 1 : 5;
            }
        } else if (headDir == 5) {
            if (xDiff * xDiff < this.TOL && yDiff < 0.0 && tailDir == 1) {
                point = tail;
                dir = tailDir;
            } else {
                if (yDiff > 0.0) {
                    point = new Point2D.Double(head.getX(), head.getY() + this.MINDIST);
                } else if (xDiff > 0.0 && tailDir == 3 || xDiff < 0.0 && tailDir == 7) {
                    point = new Point2D.Double(head.getX(), tail.getY());
                } else if (headDir == tailDir) {
                    pos = Math.max(head.getY(), tail.getY()) + this.MINDIST;
                    point = new Point2D.Double(head.getX(), pos);
                } else {
                    point = new Point2D.Double(head.getX(), head.getY() - yDiff / 2.0);
                }
                dir = xDiff > 0.0 ? 7 : 3;
            }
        } else if (headDir == 1) {
            if (xDiff * xDiff < this.TOL && yDiff > 0.0 && tailDir == 5) {
                point = tail;
                dir = tailDir;
            } else {
                if (yDiff < 0.0) {
                    point = new Point2D.Double(head.getX(), head.getY() - this.MINDIST);
                } else if (xDiff > 0.0 && tailDir == 3 || xDiff < 0.0 && tailDir == 7) {
                    point = new Point2D.Double(head.getX(), tail.getY());
                } else if (headDir == tailDir) {
                    pos = Math.min(head.getY(), tail.getY()) - this.MINDIST;
                    point = new Point2D.Double(head.getX(), pos);
                } else {
                    point = new Point2D.Double(head.getX(), head.getY() - yDiff / 2.0);
                }
                dir = xDiff > 0.0 ? 7 : 3;
            }
        } else {
            throw new RuntimeException("unknown dir");
        }
        Polyline2D route = this._route(point, dir, tail, tailDir);
        route.lineTo(head.getX(), head.getY());
        return route;
    }

    private int getManhattanDirection(double xDiff, double yDiff) {
        int dir = xDiff > 0.0 && yDiff > 0.0 ? (xDiff > yDiff ? 3 : 5) : (xDiff < 0.0 && yDiff < 0.0 ? (xDiff > yDiff ? 1 : 7) : (xDiff > 0.0 ? (xDiff > -yDiff ? 3 : 1) : (-xDiff > yDiff ? 7 : 5)));
        return dir;
    }
}

