/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.AbstractFigure;
import diva.canvas.AbstractFigureContainer;
import diva.canvas.BasicZList;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.TransformContext;
import diva.canvas.ZList;
import diva.util.Filter;
import diva.util.UnitIterator;
import diva.util.java2d.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class CompositeFigure
extends AbstractFigureContainer {
    private Figure _background = null;
    private Rectangle2D _cachedBounds = null;
    private ZList _children;
    private TransformContext _transformContext = new TransformContext(this);

    public CompositeFigure() {
        this._children = new BasicZList();
    }

    public CompositeFigure(ZList zlist) {
        this._children = zlist;
    }

    public CompositeFigure(Figure background) {
        this();
        this.setBackgroundFigure(background);
    }

    public void add(Figure f) {
        this._children.add(f);
        f.setParent(this);
        this._cachedBounds = null;
        f.repaint();
    }

    public void add(int index, Figure f) {
        this._children.add(index, f);
        ((AbstractFigure)f).setParent(this);
        this._cachedBounds = null;
        f.repaint();
    }

    public boolean contains(Figure f) {
        return this._children.contains(f);
    }

    public Iterator figures() {
        return this._children.figures();
    }

    public Iterator figuresFromBack() {
        return this._children.figuresFromBack();
    }

    public Iterator figuresFromFront() {
        return this._children.figuresFromFront();
    }

    public Figure get(int index) {
        return this._children.get(index);
    }

    public Figure getBackgroundFigure() {
        return this._background;
    }

    public Rectangle2D getBounds() {
        if (this._cachedBounds == null) {
            AffineTransform at = this._transformContext.getTransform();
            Rectangle2D bounds = null;
            if (this._children.getFigureCount() == 0) {
                bounds = this._background != null ? this._background.getBounds() : new Rectangle2D.Double();
            } else {
                bounds = this._children.getBounds();
                if (this._background != null) {
                    Rectangle2D.union(bounds, this._background.getBounds(), bounds);
                }
            }
            this._cachedBounds = ShapeUtilities.transformBounds(bounds, at);
        }
        return this._cachedBounds;
    }

    public ZList getChildren() {
        return this._children;
    }

    public int getFigureCount() {
        return this._children.getFigureCount();
    }

    public Point2D getOrigin() {
        if (this._background != null) {
            AffineTransform at = this._transformContext.getTransform();
            Point2D point = this._background.getOrigin();
            return at.transform(point, point);
        }
        return super.getOrigin();
    }

    public Shape getShape() {
        if (this._background != null) {
            AffineTransform at = this._transformContext.getTransform();
            return at.createTransformedShape(this._background.getShape());
        }
        return this.getBounds();
    }

    public TransformContext getTransformContext() {
        return this._transformContext;
    }

    public int indexOf(Figure f) {
        return this._children.indexOf(f);
    }

    public boolean intersects(Rectangle2D region) {
        AffineTransform t = this._transformContext.getInverseTransform();
        Rectangle2D r = ShapeUtilities.transformBounds(region, t);
        boolean result = this._background != null ? this.getBackgroundFigure().intersects(r) : false;
        Iterator i = this._children.figures();
        while (!result && i.hasNext()) {
            result = result || ((Figure)i.next()).intersects(r);
        }
        return result;
    }

    protected void invalidateCachedBounds() {
        this._cachedBounds = null;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        this._transformContext.push(g);
        if (this._background != null) {
            this._background.paint(g);
        }
        Iterator i = this._children.figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g);
        }
        this._transformContext.pop(g);
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (!this.isVisible()) {
            return;
        }
        this._transformContext.push(g);
        AffineTransform t = this._transformContext.getInverseTransform();
        Rectangle2D r = ShapeUtilities.transformBounds(region, t);
        if (this._background != null) {
            this._background.paint(g, r);
        }
        Iterator i = this._children.getIntersectedFigures(r).figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g, r);
        }
        this._transformContext.pop(g);
    }

    public Figure pick(Rectangle2D region) {
        AffineTransform at = this._transformContext.getInverseTransform();
        Figure hit = CanvasUtilities.pick(this._children.getIntersectedFigures(region = ShapeUtilities.transformBounds(region, at)).figuresFromFront(), region);
        if (hit == null && this._background != null && this._background.hit(region)) {
            return CanvasUtilities.pick(new UnitIterator(this._background), region);
        }
        return hit;
    }

    public Figure pick(Rectangle2D region, Filter filter) {
        AffineTransform at = this._transformContext.getInverseTransform();
        region = ShapeUtilities.transformBounds(region, at);
        Figure hit = CanvasUtilities.pick(this.figuresFromFront(), region, filter);
        if (hit == null && this._background != null && this._background.hit(region)) {
            return CanvasUtilities.pick(new UnitIterator(this._background), region, filter);
        }
        return hit;
    }

    public void remove(Figure f) {
        f.repaint();
        f.setParent(null);
        this._children.remove(f);
        this._cachedBounds = null;
        f.repaint();
    }

    public void remove(int index) {
        this.remove(this._children.get(index));
    }

    public void repaint(DamageRegion d) {
        d.checkCacheValid(this._transformContext);
        if (this._cachedBounds != null && !this._cachedBounds.contains(d.getBounds())) {
            this._cachedBounds = null;
        }
        super.repaint(d);
    }

    public void setBackgroundFigure(Figure background) {
        if (background != null) {
            background.setParent(null);
        }
        this._background = background;
        background.setParent(this);
        this._cachedBounds = null;
        this.repaint();
    }

    public void setIndex(int index, Figure f) {
        this._children.setIndex(index, f);
        this._cachedBounds = null;
        this.repaint();
    }

    protected void replaceChild(Figure child, Figure replacement) {
        this.repaint();
        this._children.set(this._children.indexOf(child), replacement);
        this._cachedBounds = null;
        this.repaint();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.getClass().getName());
        s.append(":Background=" + this.getBackgroundFigure() + ":others={");
        Iterator i = this.figuresFromFront();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            s.append("," + f);
        }
        s.append("}");
        return s.toString();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        ShapeUtilities.transformModify(this._cachedBounds, at);
        this._transformContext.preConcatenate(at);
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        ShapeUtilities.translateModify(this._cachedBounds, x, y);
        this._transformContext.translate(x, y);
        this.repaint();
    }
}

