/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.FigureSet;
import diva.canvas.TransformContext;
import java.util.Iterator;

public final class CanvasDebugUtilities {
    public static String printContextTree(FigureLayer rootLayer) {
        StringBuffer out = new StringBuffer("LAYER:");
        TransformContext rootContext = rootLayer.getTransformContext();
        out.append(rootContext + "\n");
        Iterator i = rootLayer.figures();
        while (i.hasNext()) {
            Figure root = (Figure)i.next();
            out.append(CanvasDebugUtilities.printHelper(root, "  ", rootContext));
        }
        return out.toString();
    }

    private static String printHelper(Figure root, String prefix, TransformContext parent) {
        String out = "";
        if (root.getTransformContext() != parent) {
            out = out + prefix + root + root.getTransformContext() + "\n";
        }
        if (root instanceof FigureSet) {
            FigureSet fs = (FigureSet)((Object)root);
            Iterator i = fs.figures();
            while (i.hasNext()) {
                Figure f = (Figure)i.next();
                out = out + CanvasDebugUtilities.printHelper(f, prefix + "  ", parent);
            }
        }
        return out;
    }
}

