/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jsky.util.TransferableList;

public class DraggableTree
extends JTree
implements DragGestureListener {
    protected DragSource fDragSource = DragSource.getDefaultDragSource();
    protected static final DragSourceListener sDragSourceListener = new TreeDragSourceListener();

    public DraggableTree() {
        this.fDragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public DraggableTree(TreeModel model) {
        super(model);
        this.fDragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public boolean isSelectionDraggable() {
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if (!this.isSelectionDraggable()) {
            return;
        }
        if (this.getSelectionCount() == 1) {
            DefaultMutableTreeNode selection;
            TreePath path = this.getSelectionPath();
            if (path != null && (selection = (DefaultMutableTreeNode)path.getLastPathComponent()) instanceof Transferable) {
                this.fDragSource.startDrag(event, event.getDragAction() == 1 ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop, (Transferable)((Object)selection), sDragSourceListener);
            }
        } else if (this.getSelectionCount() > 1) {
            TreePath[] paths = this.getSelectionPaths();
            TransferableList selections = new TransferableList();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode selection = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                if (!(selection instanceof Transferable)) continue;
                selections.add(selection);
            }
            if (selections.size() > 0) {
                this.fDragSource.startDrag(event, event.getDragAction() == 1 ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop, selections, sDragSourceListener);
            }
        }
    }

    protected static class TreeDragSourceListener
    implements DragSourceListener {
        protected TreeDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
        }

        @Override
        public void dragExit(DragSourceEvent DragSourceEvent2) {
        }

        @Override
        public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
        }
    }
}

