/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jsky.util.ExceptionHandler;
import org.xml.sax.SAXParseException;

public class DialogUtil {
    private static List<ExceptionHandler> _exceptionHandlerList;

    public static JFrame getActiveFrame() {
        for (Frame f : JFrame.getFrames()) {
            if (!(f instanceof JFrame) || !f.isActive()) continue;
            return (JFrame)f;
        }
        return null;
    }

    public static void addExceptionHandler(ExceptionHandler handler) {
        if (_exceptionHandlerList == null) {
            _exceptionHandlerList = new LinkedList<ExceptionHandler>();
        }
        _exceptionHandlerList.add(handler);
    }

    public static void removeExceptionHandler(ExceptionHandler handler) {
        if (_exceptionHandlerList != null) {
            _exceptionHandlerList.remove(handler);
        }
    }

    public static void error(Component parentComponent, String msg) {
        JOptionPane.showMessageDialog(parentComponent, msg, "Error", 0);
    }

    public static void error(String msg) {
        DialogUtil.error((Component)DialogUtil.getActiveFrame(), msg);
    }

    public static void error(Component parentComponent, Exception e) {
        if (_exceptionHandlerList != null && _exceptionHandlerList.size() != 0) {
            ListIterator<ExceptionHandler> it = _exceptionHandlerList.listIterator();
            while (it.hasNext()) {
                ExceptionHandler handler = (ExceptionHandler)it.next();
                if (!handler.handleException(e)) continue;
                return;
            }
        }
        e.printStackTrace();
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        String s = t.getMessage();
        if (t instanceof UnknownHostException) {
            s = "Unknown host: " + s;
        } else if (t instanceof FileNotFoundException) {
            s = "File not found: " + s;
        } else if (t instanceof SAXParseException) {
            s = "XML parsing error: " + s;
        } else if (s == null || s.trim().length() == 0) {
            s = t.toString();
        }
        JOptionPane.showMessageDialog(parentComponent, s, "Error", 0);
    }

    public static void error(Exception e) {
        DialogUtil.error((Component)DialogUtil.getActiveFrame(), e);
    }

    public static void message(Component parentComponent, String msg) {
        JOptionPane.showMessageDialog(parentComponent, msg, "Message", 1);
    }

    public static void message(String msg) {
        DialogUtil.message(DialogUtil.getActiveFrame(), msg);
    }

    public static String input(Component parentComponent, String msg, String initialValue) {
        return JOptionPane.showInputDialog(parentComponent, msg, initialValue);
    }

    public static String input(Component parentComponent, String msg) {
        return JOptionPane.showInputDialog(parentComponent, msg, "Input", 3);
    }

    public static String input(String msg) {
        return DialogUtil.input(DialogUtil.getActiveFrame(), msg);
    }

    public static Object input(Component parentComponent, String msg, Object[] choices, Object initialValue) {
        return JOptionPane.showInputDialog(parentComponent, msg, "Input", 3, null, choices, initialValue);
    }

    public static int confirm(Component parentComponent, String msg) {
        return JOptionPane.showConfirmDialog(parentComponent, msg);
    }

    public static int confirm(String msg) {
        return DialogUtil.confirm(DialogUtil.getActiveFrame(), msg);
    }
}

