/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import jsky.util.gui.DialogUtil;

public final class JarManager {
    public void show(OutputStream out) throws IOException {
        String classPath = System.getProperty("java.class.path");
        String sep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classPath, sep);
        Properties props = new Properties();
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            if (!fileName.endsWith(".jar")) continue;
            File file = new File(fileName);
            long size = file.length();
            long sum = this._getChecksum(file);
            props.setProperty(file.getName(), "" + size + " " + sum);
        }
        props.store(out, "JarManager v1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _getChecksum(File file) throws IOException {
        byte[] buf = new byte[8192];
        CRC32 cs = new CRC32();
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            while (in.read(buf) != -1) {
                cs.update(buf, 0, buf.length);
            }
        }
        return cs.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(String fileName) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            this.show(out);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    DialogUtil.error(ex);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            new JarManager().show(System.out);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
        System.exit(0);
    }
}

