/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class I18N {
    private static final Logger LOG = Logger.getLogger(I18N.class.getName());
    private static Map<String, I18N> _pkgBundles = new Hashtable<String, I18N>();
    private String _baseName;
    private Locale _locale = Locale.getDefault();

    public static I18N getInstance(Class c) {
        String pkgName = c.getPackage().getName();
        I18N i18n = _pkgBundles.get(pkgName);
        if (i18n != null) {
            return i18n;
        }
        i18n = new I18N(c);
        _pkgBundles.put(pkgName, i18n);
        return i18n;
    }

    private I18N(Class c) {
        this._baseName = c.getPackage().getName() + ".i18n.gui";
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getString(String key) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(this._baseName, this._locale);
            String text = rb.getString(key);
            return text != null ? text : key;
        }
        catch (MissingResourceException mre) {
            if (this._locale != Locale.US) {
                this._locale = Locale.US;
                return this.getString(key);
            }
            LOG.warning(mre.getMessage());
            return key;
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return key;
        }
    }

    public String getString(String key, Object ... params) {
        String pattern = this.getString(key);
        if (pattern == null) {
            return null;
        }
        MessageFormat mf = new MessageFormat(pattern);
        mf.setLocale(this._locale);
        return mf.format(params);
    }

    public static void main(String[] args) {
        I18N i18n = I18N.getInstance(I18N.class);
        System.out.println("hello = " + i18n.getString("hello"));
        System.out.println("test1 = " + i18n.getString("test1"));
        System.out.println("test1 with 2 args = " + i18n.getString("test1", "One", "Two"));
        System.out.println("test1 with 3 args = " + i18n.getString("test1", "One", "Two", 3));
    }
}

