/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.Serializable;
import jsky.science.Coordinates;

public class CoordinatesOffset
implements Serializable {
    public static final int NUM_DECIMAL = 2;
    private double fRa;
    private double fDec;
    private static final long serialVersionUID = 1L;

    public CoordinatesOffset() {
        this(0.0, 0.0);
    }

    public CoordinatesOffset(CoordinatesOffset co) {
        this(co.getRa(), co.getDec());
    }

    public CoordinatesOffset(double ra, double dec) {
        this.set(ra, dec);
    }

    public CoordinatesOffset(double ra, double dec, String units) {
        this.set(Coordinates.convert(ra, units, Coordinates.DEGREE), Coordinates.convert(dec, units, Coordinates.DEGREE));
    }

    public double getRa() {
        return this.fRa;
    }

    public double getDec() {
        return this.fDec;
    }

    public double getRa(String units) {
        return Coordinates.convert(this.fRa, Coordinates.DEGREE, units);
    }

    public double getDec(String units) {
        return Coordinates.convert(this.fDec, Coordinates.DEGREE, units);
    }

    public void set(double ra, double dec) {
        this.fRa = CoordinatesOffset.validateRa(ra);
        this.fDec = Coordinates.validateDec(dec);
    }

    public static final double validateRa(double ra) {
        double newRA = ra % 360.0;
        return newRA;
    }

    public void translate(double dra, double ddec) {
        this.set(this.fRa + dra, this.fDec + ddec);
    }

    public CoordinatesOffset add(CoordinatesOffset delta) {
        return new CoordinatesOffset(this.fRa + delta.fRa, this.fDec + delta.fDec);
    }

    public CoordinatesOffset subtract(CoordinatesOffset delta) {
        return new CoordinatesOffset(this.fRa - delta.fRa, this.fDec - delta.fDec);
    }

    public void rotate(double angleRad) {
        double raNew = this.fRa * Math.cos(angleRad) - this.fDec * Math.sin(angleRad);
        double decNew = this.fRa * Math.sin(angleRad) + this.fDec * Math.cos(angleRad);
        this.set(raNew, decNew);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CoordinatesOffset) {
            CoordinatesOffset offset = (CoordinatesOffset)obj;
            return this.fRa == offset.fRa && this.fDec == offset.fDec;
        }
        return false;
    }

    public String toString() {
        Coordinates tempCoord = new Coordinates(this.fRa, this.fDec);
        return tempCoord.toString();
    }
}

