/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ROI;
import javax.media.jai.registry.RIFRegistry;
import jsky.image.operator.CutLevelOpImage;

public class CutLevelDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "cutlevel"}, {"LocalName", "cutlevel"}, {"Vendor", "jsky"}, {"Description", "Calculate image min and max values, ignoring the given blank or bad pixel value"}, {"DocURL", "http://archive.eso.org/jsky/jsky-doc/api/jsky/image/operator/CutLevelDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "The region of the image to scan"}, {"arg1Desc", "Ignore pixels with this value."}, {"arg2Desc", "Median value (min+max/2.) to use in place of bad pixels."}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    private static final String[] paramNames = new String[]{"roi", "ignore", "median"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Double.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{null, null, null};
    private static final Object[] validParamValues = new Object[]{null, null, null};

    public CutLevelDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, validParamValues);
    }

    public static void register() {
        CutLevelDescriptor CutLevelDescriptor2 = new CutLevelDescriptor();
        String operationName = "cutlevel";
        String productName = "jsky";
        OperationRegistry or = JAI.getDefaultInstance().getOperationRegistry();
        or.registerDescriptor(CutLevelDescriptor2);
        RIFRegistry.register(or, operationName, productName, CutLevelDescriptor2);
    }

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        if (!this.validateParameters(paramBlock)) {
            return null;
        }
        return new CutLevelOpImage(paramBlock.getRenderedSource(0), (ROI)paramBlock.getObjectParameter(0), (Double)paramBlock.getObjectParameter(1), (Double)paramBlock.getObjectParameter(2));
    }

    public boolean validateParameters(ParameterBlock paramBlock) {
        int n = this.getParameterListDescriptor(this.getSupportedModes()[0]).getNumParameters();
        for (int i = 0; i < n; ++i) {
            Object arg = paramBlock.getObjectParameter(i);
            if (arg == null) {
                return false;
            }
            if (!(i == 0 ? !(arg instanceof ROI) : !(arg instanceof Double))) continue;
            return false;
        }
        return true;
    }
}

