/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.gui.MainImageDisplay;
import jsky.science.IQE;

public class PickObjectStatistics {
    public static final int ID = 0;
    public static final int RA = 1;
    public static final int DEC = 2;
    public static final int IMAGE_X = 3;
    public static final int IMAGE_Y = 4;
    public static final int FWHM_X = 5;
    public static final int FWHM_Y = 6;
    public static final int ANGLE = 7;
    public static final int PEAK = 8;
    public static final int BACKGROUND = 9;
    public static final String[] FIELD_NAMES = new String[]{"Id", "RA", "Dec", "Image_X", "Image_Y", "FWHM_X", "FWHM_Y", "Angle", "Peak", "Background"};
    public static final int NUM_FIELDS = FIELD_NAMES.length;
    private MainImageDisplay _imageDisplay;
    private WorldCoords _centerPos;
    private double _imageX;
    private double _imageY;
    private IQE _iqe;

    PickObjectStatistics(MainImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
    }

    PickObjectStatistics(MainImageDisplay imageDisplay, int x, int y, int w, int h) {
        this(imageDisplay);
        this.calculateStatistics(x, y, w, h);
    }

    public WorldCoords getCenterPos() {
        return this._centerPos;
    }

    public double getImageX() {
        return this._imageX;
    }

    public double getImageY() {
        return this._imageY;
    }

    public double getFwhmX() {
        return this._iqe.getFwhmX();
    }

    public double getFwhmY() {
        return this._iqe.getFwhmY();
    }

    public double getAngle() {
        return this._iqe.getAngle();
    }

    public double getObjectPeak() {
        return this._iqe.getObjectPeak();
    }

    public double getMeanBackground() {
        return this._iqe.getMeanBackground();
    }

    public boolean getStatus() {
        return this._iqe != null && this._iqe.getStatus();
    }

    public void calculateStatistics(int x, int y, int w, int h) {
        Point2D.Double center;
        Rectangle r = new Rectangle(x, y, w, h);
        float[] ar = this._imageDisplay.getPixelValues(r, 0);
        if (ar == null) {
            return;
        }
        this._iqe = new IQE(ar, w, h);
        if (this._iqe.getStatus()) {
            center = new Point2D.Double((double)x + this._iqe.getMeanX(), (double)(y + h - 1) - this._iqe.getMeanY());
            if (this._imageDisplay.getScale() > 1.0f) {
                center.x += 0.5;
                center.y += 0.5;
            }
        } else {
            center = new Point2D.Double((double)x + (double)w / 2.0, (double)y + (double)h / 2.0);
        }
        CoordinateConverter cc = this._imageDisplay.getCoordinateConverter();
        cc.userToImageCoords(center, false);
        this._imageX = center.x;
        this._imageY = center.y;
        cc.imageToWorldCoords(center, false);
        this._centerPos = new WorldCoords(center, cc.getEquinox());
    }

    public static FieldDesc[] getFields() {
        FieldDesc[] fields = new FieldDescAdapter[NUM_FIELDS];
        for (int i = 0; i < NUM_FIELDS; ++i) {
            fields[i] = new FieldDescAdapter(FIELD_NAMES[i]);
        }
        fields[0].setIsId(true);
        fields[1].setIsRA(true);
        fields[2].setIsDec(true);
        return fields;
    }

    public Vector<Object> getRow() {
        if (this._centerPos == null || this._iqe == null) {
            return null;
        }
        Vector<Object> row = new Vector<Object>(NUM_FIELDS);
        block12: for (int i = 0; i < NUM_FIELDS; ++i) {
            switch (i) {
                case 0: {
                    row.add("P" + System.currentTimeMillis());
                    continue block12;
                }
                case 1: {
                    row.add(this._centerPos.getRA().toString());
                    continue block12;
                }
                case 2: {
                    row.add(this._centerPos.getDec().toString());
                    continue block12;
                }
                case 3: {
                    row.add(this._imageX);
                    continue block12;
                }
                case 4: {
                    row.add(this._imageY);
                    continue block12;
                }
                case 5: {
                    double d1 = this._iqe.getFwhmX();
                    if (d1 != 0.0) {
                        row.add(d1);
                        continue block12;
                    }
                    row.add(null);
                    continue block12;
                }
                case 6: {
                    double d2 = this._iqe.getFwhmY();
                    if (d2 != 0.0) {
                        row.add(d2);
                        continue block12;
                    }
                    row.add(null);
                    continue block12;
                }
                case 7: {
                    row.add(this._iqe.getAngle());
                    continue block12;
                }
                case 8: {
                    row.add(this._iqe.getObjectPeak());
                    continue block12;
                }
                case 9: {
                    row.add(this._iqe.getMeanBackground());
                }
            }
        }
        return row;
    }
}

