/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageUtil;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageDisplay;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.gui.MainImageDisplay;

public class ImageZoom
extends JComponent
implements ChangeListener,
ImageGraphicsHandler {
    public static final int DEFAULT_SIZE = 152;
    private MainImageDisplay _mainImageDisplay;
    private ImageDisplay _imageDisplay;
    private int _zoomWidth;
    private int _zoomHeight;
    private float _zoomFactor;
    private boolean _enabled = true;
    private boolean _active = true;
    private boolean _propagateScale = true;
    private Rectangle2D.Double[] _rect = new Rectangle2D.Double[2];

    public ImageZoom(MainImageDisplay mainImageDisplay, int width, int height, float factor) {
        this._imageDisplay = new ImageDisplay("zoom window");
        this._imageDisplay.addImageGraphicsHandler(this);
        this._imageDisplay.setAutoCenterImage(false);
        this._zoomFactor = factor;
        this._zoomWidth = width;
        this._zoomHeight = height;
        this._rect[0] = new Rectangle2D.Double();
        this._rect[1] = new Rectangle2D.Double();
        this._imageDisplay.setScaleHints(ImageUtil.getTileCacheHint(0, this._zoomWidth, this._zoomHeight));
        ImageDisplay c = this._imageDisplay;
        c.setPreferredSize(new Dimension(this._zoomWidth, this._zoomHeight));
        this.setLayout(new BorderLayout());
        this.add((Component)c, "Center");
        this.setMainImageDisplay(mainImageDisplay);
    }

    public ImageZoom(MainImageDisplay mainImageDisplay) {
        this(mainImageDisplay, 152, 152, 4.0f);
    }

    public ImageZoom() {
        this(null);
    }

    public void setZoomFactor(float factor) {
        if (factor < 1.0f) {
            return;
        }
        this._zoomFactor = factor;
    }

    public float getZoomFactor() {
        return this._zoomFactor;
    }

    public void setMainImageDisplay(MainImageDisplay mainImageDisplay) {
        this._mainImageDisplay = mainImageDisplay;
        if (this._mainImageDisplay != null) {
            if (this._propagateScale) {
                if (this._mainImageDisplay.isPrescaled()) {
                    this._imageDisplay.setScale(this._zoomFactor, this._mainImageDisplay.getScale() * this._zoomFactor);
                } else {
                    this._imageDisplay.setScale(this._mainImageDisplay.getScale() * this._zoomFactor);
                }
            }
            this._imageDisplay.setImageProcessor(this._mainImageDisplay.getImageProcessor());
            this._mainImageDisplay.addChangeListener(this);
            ((Component)((Object)this._mainImageDisplay)).addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    ImageZoom.this.zoom(e.getX(), e.getY(), false);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    ImageZoom.this.zoom(e.getX(), e.getY(), false);
                }
            });
        }
    }

    public BasicImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    public MainImageDisplay getMainImageDisplay() {
        return this._mainImageDisplay;
    }

    @Override
    public void setEnabled(boolean b) {
        this._enabled = b;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setActive(boolean b) {
        this._active = b;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setPropagateScale(boolean b) {
        this._propagateScale = b;
    }

    public boolean isPropagateScale() {
        return this._propagateScale;
    }

    public void zoom(int x, int y, boolean force) {
        if (!this._active && !force) {
            return;
        }
        Point2D.Double origin = new Point2D.Double(x, y);
        this._mainImageDisplay.getCoordinateConverter().screenToUserCoords(origin, false);
        this._imageDisplay.getCoordinateConverter().userToCanvasCoords(origin, false);
        origin.x -= (double)this._zoomWidth / 2.0;
        origin.y -= (double)this._zoomHeight / 2.0;
        this._imageDisplay.setOrigin(origin);
        this._imageDisplay.updateImage();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImageChangeEvent e = (ImageChangeEvent)ce;
        if (e.isNewScale() || e.isNewImage() && !e.isBefore()) {
            if (!this._propagateScale) {
                this.setZoomFactor(this._imageDisplay.getScale() / this._mainImageDisplay.getScale());
            }
            if (this._mainImageDisplay.isPrescaled()) {
                this._imageDisplay.setScale(this._zoomFactor, this._mainImageDisplay.getScale() * this._zoomFactor);
            } else {
                this._imageDisplay.setScale(this._mainImageDisplay.getScale() * this._zoomFactor);
            }
            this.updateRect();
        }
    }

    public void updateRect() {
        if (!this._imageDisplay.isInitialized() || !this._mainImageDisplay.isInitialized()) {
            return;
        }
        double f = this._mainImageDisplay.getScale();
        if (f <= 1.0) {
            f = this._zoomFactor;
            this._rect[0].x = (double)this.getWidth() / 2.0;
            this._rect[0].y = (double)this.getHeight() / 2.0;
            this._rect[0].width = this._rect[0].height = f;
        } else {
            this._rect[0].x = (double)this.getWidth() / 2.0 - (f *= (double)this._zoomFactor) / 2.0;
            this._rect[0].y = (double)this.getHeight() / 2.0 - f / 2.0;
            this._rect[0].width = this._rect[0].height = f;
        }
        this._rect[1].x = this._rect[0].x - 1.0;
        this._rect[1].y = this._rect[0].y - 1.0;
        this._rect[1].width = this._rect[1].height = this._rect[0].width + 2.0;
    }

    @Override
    public void drawImageGraphics(BasicImageDisplay imageDisplay, Graphics2D g) {
        g.setColor(Color.white);
        g.draw(this._rect[0]);
        g.setColor(Color.black);
        g.draw(this._rect[1]);
    }
}

