/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsky.image.BasicImageReadableProcessor;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageColorITTs;
import jsky.image.ImageColorLUTs;
import jsky.image.ImageProcessor;
import jsky.util.I18N;
import jsky.util.gui.SwingUtil;

public class ImageColors
extends JPanel {
    private static final I18N _I18N = I18N.getInstance(ImageColors.class);
    private BasicImageReadableProcessor _imageDisplay;
    private ImageProcessor _imageProcessor;
    private String[] _colormaps = ImageColorLUTs.getLUTNames();
    private JList _colormapList = new JList<String>(this._colormaps);
    private String[] _itts = ImageColorITTs.getITTNames();
    private JList _intensityList = new JList<String>(this._itts);
    private JRadioButton _linearScale = new JRadioButton(_I18N.getString("linearScale"));
    private JRadioButton _logScale = new JRadioButton(_I18N.getString("logarithmic"));
    private JRadioButton _sqrtScale = new JRadioButton(_I18N.getString("squareRoot"));
    private JRadioButton _histeqScale = new JRadioButton(_I18N.getString("histogram"));
    private boolean _ignoreEvents = false;

    public ImageColors(BasicImageReadableProcessor imageDisplay) {
        this._imageDisplay = imageDisplay;
        this._imageProcessor = imageDisplay.getImageProcessor();
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeMainPanel(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this._imageProcessor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewColormap()) {
                    ImageColors.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    protected JPanel makeMainPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeColorScalePanel());
        panel.add(this.makeColormapListPanel());
        panel.add(this.makeIntensityListPanel());
        return panel;
    }

    protected JPanel makeColorScalePanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("colorScaleAlgorithm"), 2, 2));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._linearScale);
        panel.add(this._logScale);
        panel.add(this._sqrtScale);
        panel.add(this._histeqScale);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this._linearScale);
        grp.add(this._logScale);
        grp.add(this._sqrtScale);
        grp.add(this._histeqScale);
        this._linearScale.setSelected(true);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ImageColors.this._ignoreEvents) {
                    ImageColors.this.setScaleAlgorithm(e.getActionCommand());
                }
            }
        };
        this._linearScale.addActionListener(l);
        this._logScale.addActionListener(l);
        this._sqrtScale.addActionListener(l);
        this._histeqScale.addActionListener(l);
        return panel;
    }

    protected void setScaleAlgorithm(String name) {
        if (name.equals(_I18N.getString("linearScale"))) {
            this._imageProcessor.setScaleAlgorithm(0);
        } else if (name.equals(_I18N.getString("logarithmic"))) {
            this._imageProcessor.setScaleAlgorithm(2);
        } else if (name.equals(_I18N.getString("squareRoot"))) {
            this._imageProcessor.setScaleAlgorithm(1);
        } else if (name.equals(_I18N.getString("histogram"))) {
            this._imageProcessor.setScaleAlgorithm(3);
        }
        this._imageProcessor.update();
    }

    protected JPanel makeColormapListPanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("colormap"), 2, 2));
        JScrollPane scrollPane = new JScrollPane(this._colormapList);
        panel.add(scrollPane);
        this._colormapList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!ImageColors.this._ignoreEvents) {
                    Object[] selectedValues;
                    JList src = (JList)evt.getSource();
                    if (!evt.getValueIsAdjusting() && (selectedValues = src.getSelectedValues()).length >= 1) {
                        ImageColors.this.setColormap((String)selectedValues[0]);
                    }
                }
            }
        });
        return panel;
    }

    protected void setColormap(String name) {
        this._imageProcessor.setColorLookupTable(name);
        this._imageProcessor.update();
    }

    protected JPanel makeIntensityListPanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("intensity"), 2, 2));
        JScrollPane scrollPane = new JScrollPane(this._intensityList);
        panel.add(scrollPane);
        this._intensityList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!ImageColors.this._ignoreEvents) {
                    Object[] selectedValues;
                    JList src = (JList)evt.getSource();
                    if (!evt.getValueIsAdjusting() && (selectedValues = src.getSelectedValues()).length >= 1) {
                        ImageColors.this.setIntensityLookupTable((String)selectedValues[0]);
                    }
                }
            }
        });
        return panel;
    }

    protected void setIntensityLookupTable(String name) {
        this._imageProcessor.setIntensityLookupTable(name);
        this._imageProcessor.update();
    }

    protected JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton resetButton = new JButton(_I18N.getString("reset"));
        resetButton.setToolTipText(_I18N.getString("resetTip"));
        panel.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImageColors.this.reset();
            }
        });
        JButton closeButton = new JButton(_I18N.getString("close"));
        closeButton.setToolTipText(_I18N.getString("closeTip"));
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImageColors.this.close();
            }
        });
        return panel;
    }

    protected void reset() {
        this._imageProcessor.setDefaultColormap();
        this._imageProcessor.update();
        this._linearScale.setSelected(true);
        this._colormapList.setSelectedValue("Real", true);
        this._intensityList.setSelectedValue("Ramp", true);
    }

    void updateDisplay() {
        this._ignoreEvents = true;
        try {
            int scaleAlg = this._imageProcessor.getScaleAlgorithm();
            switch (scaleAlg) {
                case 0: {
                    this._linearScale.setSelected(true);
                    break;
                }
                case 1: {
                    this._sqrtScale.setSelected(true);
                    break;
                }
                case 2: {
                    this._logScale.setSelected(true);
                    break;
                }
                case 3: {
                    this._histeqScale.setSelected(true);
                }
            }
            this._colormapList.setSelectedValue(this._imageProcessor.getColorLookupTableName(), true);
            this._intensityList.setSelectedValue(this._imageProcessor.getIntensityLookupTableName(), true);
        }
        finally {
            this._ignoreEvents = false;
        }
    }

    protected void close() {
        JFrame parent = SwingUtil.getFrame(this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }
}

