/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import diva.canvas.GraphicsPane;
import diva.canvas.JCanvas;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.coords.CoordinateConverter;
import jsky.coords.WCSTransform;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.graphics.CanvasGraphics;
import jsky.image.EmptyRenderedImage;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.fits.FITSKeywordProvider;
import jsky.image.fits.codec.FITSImage;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ImageLayer;
import jsky.image.gui.GraphicsImageDisplay;
import jsky.image.gui.ImageCoordinateConverter;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.operator.ImageOps;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DialogUtil;

public class DivaGraphicsImageDisplay
extends JCanvas
implements GraphicsImageDisplay {
    private ImageProcessor _imageProcessor;
    private PlanarImage _displayImage;
    private PlanarImage _pendingImage;
    private SampleModel _sampleModel;
    private ColorModel _colorModel;
    private CoordinateConverter _coordinateConverter;
    private CanvasGraphics _canvasGraphics;
    private ImageLayer _imageLayer;
    private WorldCoordinateConverter _wcs;
    private boolean _noInitWCS = false;
    private AffineTransform _affineTransform;
    private float _scale = 1.0f;
    private boolean _prescaled = false;
    private RenderingHints _scaleHints;
    private Point2D.Double _origin = new Point2D.Double(0.0, 0.0);
    private boolean _autoCenterImage = true;
    private boolean _centered = false;
    private Interpolation _interpolation = new InterpolationNearest();
    private int _minTileX;
    private int _maxTileX;
    private int _minTileY;
    private int _maxTileY;
    private int _tileWidth;
    private int _tileHeight;
    private int _tileGridXOffset;
    private int _tileGridYOffset;
    private FITSImage _fitsImage;
    private boolean _immediateMode = true;
    private boolean _updateGraphicsFlag = false;
    private EventListenerList _listenerList = new EventListenerList();
    private int _savedImageWidth;
    private int _savedImageHeight;
    private float _savedScale;

    public DivaGraphicsImageDisplay(GraphicsPane pane, ImageProcessor imageProcessor, String name) {
        super(pane);
        this.setName(name);
        this.setImageProcessor(imageProcessor);
        imageProcessor.setName(name);
        this._coordinateConverter = new ImageCoordinateConverter(this);
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(255, 255));
        this._canvasGraphics = this.makeCanvasGraphics();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DivaGraphicsImageDisplay.this._pendingImage != null) {
                    DivaGraphicsImageDisplay.this.setImage(DivaGraphicsImageDisplay.this._pendingImage);
                    DivaGraphicsImageDisplay.this._pendingImage = null;
                }
            }
        });
    }

    public DivaGraphicsImageDisplay(ImageProcessor imageProcessor, String name) {
        this(new GraphicsPane(), imageProcessor, name);
    }

    public DivaGraphicsImageDisplay(String name) {
        this(new ImageProcessor(), name);
    }

    public DivaGraphicsImageDisplay() {
        this("Image Display");
    }

    protected CanvasGraphics makeCanvasGraphics() {
        DivaImageGraphics g = new DivaImageGraphics(this);
        this._imageLayer = g.getImageLayer();
        return g;
    }

    @Override
    public PlanarImage getImage() {
        return this._imageProcessor.getSourceImage();
    }

    @Override
    public PlanarImage getDisplayImage() {
        return this._displayImage;
    }

    @Override
    public CoordinateConverter getCoordinateConverter() {
        return this._coordinateConverter;
    }

    @Override
    public CanvasGraphics getCanvasGraphics() {
        return this._canvasGraphics;
    }

    @Override
    public void setImageProcessor(ImageProcessor imageProcessor) {
        this._imageProcessor = imageProcessor;
        this._wcs = null;
        imageProcessor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewAngle()) {
                    DivaGraphicsImageDisplay.this._updateGraphicsFlag = true;
                }
                DivaGraphicsImageDisplay.this.updateImage();
            }
        });
    }

    @Override
    public ImageProcessor getImageProcessor() {
        return this._imageProcessor;
    }

    @Override
    public void setImage(PlanarImage im) {
        if (!this._noInitWCS) {
            this._imageLayer.setVisible(true);
        }
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (cw == 0) {
            this._pendingImage = im;
            return;
        }
        double dw = (float)im.getWidth() * this._scale;
        double dh = (float)im.getHeight() * this._scale;
        double x = Math.max((dw - (double)cw) / 2.0, 0.0);
        double y = Math.max((dh - (double)ch) / 2.0, 0.0);
        Rectangle2D.Double region = new Rectangle2D.Double(x / (double)this._scale, y / (double)this._scale, (float)cw / this._scale, (float)ch / this._scale);
        this.newImage(true);
        this._imageProcessor.setSourceImage(im, region);
        this._imageProcessor.update();
        this.newImage(false);
    }

    public void setImage(FITSImage fitsImage) {
        this._fitsImage = fitsImage;
        float scale = this._fitsImage.getScale();
        if (scale < 1.0f) {
            this._scale = scale;
        }
        this._prescaled = this._fitsImage.getSubsample() != 1;
        this.setImage(PlanarImage.wrapRenderedImage(this._fitsImage));
    }

    @Override
    public int getImageWidth() {
        if (this._fitsImage != null) {
            return this._fitsImage.getRealWidth();
        }
        PlanarImage image = this.getImage();
        if (image != null) {
            return image.getWidth();
        }
        return 0;
    }

    @Override
    public int getImageHeight() {
        if (this._fitsImage != null) {
            return this._fitsImage.getRealHeight();
        }
        PlanarImage image = this.getImage();
        if (image != null) {
            return image.getHeight();
        }
        return 0;
    }

    @Override
    public FITSImage getFitsImage() {
        return this._fitsImage;
    }

    protected void clearFitsImage() {
        this._fitsImage = null;
    }

    protected void newImage(boolean before) {
        if (before) {
            if (this._fitsImage != null) {
                this._fitsImage.clearTileCache();
            }
            this._fitsImage = null;
            this._centered = true;
            if (!this._noInitWCS) {
                this._wcs = null;
            }
        } else {
            Object o;
            this._affineTransform = this.getAffineTransform();
            PlanarImage im = this.getImage();
            if (im != null && (o = im.getProperty("#fits_image")) != null && o instanceof FITSImage) {
                this._fitsImage = (FITSImage)o;
                if (!this._noInitWCS) {
                    this.initWCS();
                }
            }
            this._updateGraphicsFlag = true;
        }
    }

    protected void initWCS() {
        if (this._fitsImage == null) {
            return;
        }
        if (this._wcs != null) {
            return;
        }
        try {
            this._wcs = new WCSTransform(new FITSKeywordProvider(this._fitsImage));
        }
        catch (IllegalArgumentException e) {
            this._wcs = null;
            return;
        }
        if (!this._wcs.isWCS()) {
            this._wcs = null;
        }
    }

    @Override
    public boolean isWCS() {
        return this._wcs != null;
    }

    @Override
    public WorldCoordinateConverter getWCS() {
        return this._wcs;
    }

    @Override
    public void setWCS(WorldCoordinateConverter wcs) {
        this._wcs = wcs;
    }

    @Override
    public WorldCoords getBasePos() {
        if (this.isWCS()) {
            WorldCoordinateConverter wcs = this.getWCS();
            return new WorldCoords(wcs.getWCSCenter(), wcs.getEquinox());
        }
        return new WorldCoords();
    }

    @Override
    public void clear() {
        if (this.isWCS()) {
            Point2D.Double p = this._wcs.getWCSCenter();
            this.blankImage(p.x, p.y);
        } else {
            this.blankImage(0.0, 0.0);
        }
    }

    @Override
    public boolean isClear() {
        return this._displayImage == null || !this._imageLayer.isVisible();
    }

    @Override
    public void blankImage(double ra, double dec) {
        int w = 900;
        this._wcs = new WCSTransform(ra, dec, 1.7, 1.7, (double)w / 2.0, (double)w / 2.0, w, w, 180.0, 2000, 2000.0, "-SIN");
        this._noInitWCS = true;
        try {
            this._scale = 1.0f;
            if (this._fitsImage != null) {
                this._fitsImage.clearTileCache();
                this._fitsImage.close();
                this._fitsImage = null;
            }
            this.setImage(PlanarImage.wrapRenderedImage(new EmptyRenderedImage(w, w)));
            this._imageLayer.setVisible(false);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noInitWCS = false;
    }

    @Override
    public synchronized void updateImage() {
        this.updateImage(this._imageProcessor.getDisplayImage());
        if (this._updateGraphicsFlag) {
            this._updateGraphicsFlag = false;
            this.transformGraphics();
        } else {
            this._affineTransform = this.getAffineTransform();
        }
    }

    protected void updateImage(PlanarImage im) {
        if (im == null) {
            return;
        }
        this.centerImage(im);
        this._displayImage = this.scale(im);
        this._sampleModel = this._displayImage.getSampleModel();
        if (this._sampleModel == null) {
            return;
        }
        this._colorModel = this._displayImage.getColorModel();
        if (this._colorModel == null) {
            this._colorModel = PlanarImage.createColorModel(this._sampleModel);
            if (this._colorModel == null) {
                throw new IllegalArgumentException("no color model");
            }
        }
        this._minTileX = this._displayImage.getMinTileX();
        this._maxTileX = this._displayImage.getMinTileX() + this._displayImage.getNumXTiles() - 1;
        this._minTileY = this._displayImage.getMinTileY();
        this._maxTileY = this._displayImage.getMinTileY() + this._displayImage.getNumYTiles() - 1;
        this._tileWidth = this._displayImage.getTileWidth();
        this._tileHeight = this._displayImage.getTileHeight();
        this._tileGridXOffset = this._displayImage.getTileGridXOffset();
        this._tileGridYOffset = this._displayImage.getTileGridYOffset();
        this.repaint();
    }

    @Override
    public void setAutoCenterImage(boolean b) {
        this._autoCenterImage = b;
    }

    @Override
    public boolean isAutoCenterImage() {
        return this._autoCenterImage;
    }

    protected void centerImage(PlanarImage im) {
        if (!this._autoCenterImage) {
            return;
        }
        float scale = this._scale;
        if (this._prescaled) {
            scale = 1.0f;
        }
        int w = im.getWidth();
        int h = im.getHeight();
        if (w == this._savedImageWidth && h == this._savedImageHeight && scale == this._savedScale) {
            return;
        }
        this._savedImageWidth = w;
        this._savedImageHeight = h;
        this._savedScale = scale;
        double dw = (float)w * scale;
        double dh = (float)h * scale;
        int cw = this.getWidth();
        int ch = this.getHeight();
        double x = this._origin.x;
        double y = this._origin.y;
        boolean center = false;
        if (dw < (double)cw || this._centered) {
            x = (dw - (double)cw) / 2.0;
            center = true;
        }
        if (dh < (double)ch || this._centered) {
            y = (dh - (double)ch) / 2.0;
            center = true;
        }
        if (center) {
            this._origin.x = x;
            this._origin.y = y;
            this._centered = true;
        }
    }

    private int XtoTileX(int x) {
        return (int)Math.floor((double)(x - this._tileGridXOffset) / (double)this._tileWidth);
    }

    private int YtoTileY(int y) {
        return (int)Math.floor((double)(y - this._tileGridYOffset) / (double)this._tileHeight);
    }

    private int TileXtoX(int tx) {
        return tx * this._tileWidth + this._tileGridXOffset;
    }

    private int TileYtoY(int ty) {
        return ty * this._tileHeight + this._tileGridYOffset;
    }

    private int maxInt(int a, int b) {
        return a > b ? a : b;
    }

    private int minInt(int a, int b) {
        return a <= b ? a : b;
    }

    public synchronized void paintLayer(Graphics2D g2D, Rectangle2D region) {
        int h;
        int w;
        int y;
        int x;
        int componentWidth = this.getWidth();
        int componentHeight = this.getHeight();
        g2D.setComposite(AlphaComposite.Src);
        g2D.setColor(this.getBackground());
        g2D.fillRect(0, 0, componentWidth, componentHeight);
        if (this._displayImage == null || this._sampleModel == null || !this._imageLayer.isVisible()) {
            return;
        }
        Rectangle clipBounds = g2D.getClipBounds();
        Rectangle2D imageBounds = this._displayImage.getBounds().createIntersection(clipBounds);
        g2D.setClip(imageBounds);
        region = region == null ? imageBounds : region.createUnion(imageBounds);
        if (region != null) {
            x = (int)region.getX();
            y = (int)region.getY();
            w = (int)region.getWidth();
            h = (int)region.getHeight();
        } else {
            x = 0;
            y = 0;
            w = componentWidth;
            h = componentHeight;
        }
        int txmin = this.XtoTileX(x);
        txmin = this.maxInt(txmin, this._minTileX);
        txmin = this.minInt(txmin, this._maxTileX);
        int txmax = this.XtoTileX(x + w - 1);
        txmax = this.maxInt(txmax, this._minTileX);
        txmax = this.minInt(txmax, this._maxTileX);
        int tymin = this.YtoTileY(y);
        tymin = this.maxInt(tymin, this._minTileY);
        tymin = this.minInt(tymin, this._maxTileY);
        int tymax = this.YtoTileY(y + h - 1);
        tymax = this.maxInt(tymax, this._minTileY);
        tymax = this.minInt(tymax, this._maxTileY);
        Insets insets = this.getInsets();
        block0: for (int tj = tymin; tj <= tymax; ++tj) {
            for (int ti = txmin; ti <= txmax; ++ti) {
                DataBuffer dataBuffer;
                int tx = this.TileXtoX(ti);
                int ty = this.TileYtoY(tj);
                Raster tile = this._displayImage.getTile(ti, tj);
                if (tile == null || (dataBuffer = tile.getDataBuffer()) == null) continue block0;
                WritableRaster wr = WritableRaster.createWritableRaster(this._sampleModel, dataBuffer, null);
                BufferedImage bi = new BufferedImage(this._colorModel, wr, this._colorModel.isAlphaPremultiplied(), null);
                g2D.drawRenderedImage(bi, AffineTransform.getTranslateInstance(tx + insets.left, ty + insets.top));
            }
        }
        g2D.setClip(clipBounds);
        this.notifyGraphicsHandlers(g2D);
    }

    @Override
    public void addImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.add(ImageGraphicsHandler.class, igh);
    }

    @Override
    public void removeImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.remove(ImageGraphicsHandler.class, igh);
    }

    protected void notifyGraphicsHandlers(Graphics2D g) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ImageGraphicsHandler.class) continue;
            ((ImageGraphicsHandler)listeners[i + 1]).drawImageGraphics(this, g);
        }
    }

    @Override
    public void setOrigin(Point2D.Double origin) {
        this._origin = origin;
        this._centered = false;
        this._updateGraphicsFlag = true;
    }

    @Override
    public Point2D.Double getOrigin() {
        return this._origin;
    }

    @Override
    public JComponent getCanvas() {
        return this;
    }

    @Override
    public void setScale(float scale) {
        boolean needsUpdate = false;
        if (this._fitsImage != null) {
            try {
                needsUpdate = this._fitsImage.setScale(scale);
                this._prescaled = this._fitsImage.getSubsample() != 1;
            }
            catch (IOException e) {
                DialogUtil.error(e);
            }
        }
        if (!needsUpdate && scale == this._scale) {
            return;
        }
        int cw = this.getWidth();
        int ch = this.getHeight();
        Point2D.Double p = new Point2D.Double(this._origin.x + (double)cw / 2.0, this._origin.y + (double)ch / 2.0);
        this._coordinateConverter.canvasToUserCoords(p, false);
        this._scale = scale;
        this._coordinateConverter.userToCanvasCoords(p, false);
        this._origin.x = p.x - (double)cw / 2.0;
        this._origin.y = p.y - (double)ch / 2.0;
        this._updateGraphicsFlag = true;
        if (needsUpdate) {
            this._imageProcessor.setSourceImage(PlanarImage.wrapRenderedImage(this._fitsImage), this._imageProcessor);
            this._imageProcessor.update();
        }
    }

    @Override
    public float getScale() {
        return this._scale;
    }

    @Override
    public void setInterpolation(Interpolation i) {
        this._interpolation = i;
    }

    @Override
    public Interpolation getInterpolation() {
        return this._interpolation;
    }

    @Override
    public float getPixelValue(Point2D.Double p, int band) {
        PlanarImage im = this._imageProcessor.getRescaledSourceImage();
        if (im != null) {
            return this._getPixelValue(im, (int)p.getX(), (int)p.getY(), this.getImageWidth(), this.getImageHeight(), band);
        }
        return 0.0f;
    }

    private float _getPixelValue(PlanarImage im, int ix, int iy, int w, int h, int band) {
        int subsample = 1;
        if (this._fitsImage != null) {
            subsample = this._fitsImage.getSubsample();
        }
        if (!this._imageProcessor.isInvertedYAxis()) {
            iy = h - 1 - iy;
        }
        if (ix < 0 || ix >= w || iy < 0 || iy >= h) {
            return 0.0f;
        }
        int x = (int)((double)ix / (double)(this._tileWidth * subsample));
        int y = (int)((double)iy / (double)(this._tileHeight * subsample));
        if (x < 0 || y < 0) {
            return 0.0f;
        }
        Raster tile = im.getTile(x, y);
        if (tile != null) {
            try {
                return tile.getSampleFloat(ix / subsample, iy / subsample, band);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getPixelValues(Rectangle region, int band) {
        PlanarImage im = this._imageProcessor.getRescaledSourceImage();
        if (im != null) {
            int maxY;
            float[] ar = new float[region.width * region.height];
            int w = im.getWidth();
            int h = im.getHeight();
            int n = 0;
            int minX = region.x;
            int minY = region.y;
            int maxX = minX + region.width - 1;
            for (int j = maxY = minY + region.height - 1; j >= minY; --j) {
                for (int i = minX; i <= maxX; ++i) {
                    ar[n++] = this._getPixelValue(im, i, j, w, h, band);
                }
            }
            return ar;
        }
        return null;
    }

    @Override
    public void setPrescaled(boolean b) {
        this._prescaled = b;
    }

    @Override
    public boolean isPrescaled() {
        return this._prescaled;
    }

    @Override
    public void setScaleHints(RenderingHints hints) {
        this._scaleHints = hints;
    }

    @Override
    public RenderingHints getScaleHints() {
        return this._scaleHints;
    }

    protected PlanarImage scale(PlanarImage im) {
        if (im != null) {
            float tx = (float)this._origin.x;
            float ty = (float)this._origin.y;
            if (this._scale == 1.0f || this._prescaled) {
                if (tx != 0.0f || ty != 0.0f) {
                    im = ImageOps.translate(im, -tx, -ty, this._interpolation);
                }
            } else {
                im = ImageOps.scale(im, this._scale, this._scale, -tx, -ty, this._interpolation, this._scaleHints);
            }
        }
        return im;
    }

    protected void transformGraphics() {
        AffineTransform trans;
        PlanarImage im = this._imageProcessor.getSourceImage();
        if (im == null) {
            return;
        }
        try {
            trans = this._affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("warning: : " + e.toString());
            return;
        }
        this._affineTransform = this.getAffineTransform();
        if (!this._affineTransform.isIdentity()) {
            trans.preConcatenate(this._affineTransform);
        }
        if (!trans.isIdentity()) {
            this.transformGraphics(trans);
        }
    }

    protected void transformGraphics(AffineTransform trans) {
        this._canvasGraphics.transform(trans);
    }

    protected AffineTransform getAffineTransform() {
        double angle;
        AffineTransform trans = new AffineTransform();
        if (this._imageProcessor.getFlipX()) {
            trans.concatenate(new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)this.getWidth(), 0.0));
        }
        if (this._imageProcessor.getFlipY()) {
            trans.concatenate(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)this.getHeight()));
        }
        if ((angle = this._imageProcessor.getAngle()) != 0.0) {
            Point2D.Double center = new Point2D.Double((double)this.getImageWidth() / 2.0, (double)this.getImageHeight() / 2.0);
            this._coordinateConverter.userToScreenCoords(center, false);
            trans.rotate(angle, center.x, center.y);
        }
        if (this._origin.x != 0.0 || this._origin.y != 0.0) {
            trans.translate(-this._origin.x, -this._origin.y);
        }
        if (this._scale != 1.0f) {
            trans.scale(this._scale, this._scale);
        }
        return trans;
    }

    protected void scaleToFit(int width, int height) {
        float w = this.getImageWidth();
        float h = this.getImageHeight();
        if ((double)w != 0.0 && (double)h != 0.0) {
            float scale = Math.min((float)width / w, (float)height / h);
            scale = scale >= 1.0f ? (float)Math.round(scale) : 1.0f / (float)Math.round(1.0f / scale);
            this.setScale(scale);
        }
    }

    @Override
    public void scaleToFit() {
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (cw != 0) {
            this.scaleToFit(cw, ch);
        }
    }

    @Override
    public Rectangle2D.Double getVisibleArea() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        this._coordinateConverter.screenToUserCoords(p, false);
        Point2D.Double size = new Point2D.Double(this.getWidth(), this.getHeight());
        this._coordinateConverter.screenToUserCoords(size, true);
        r.setRect(p.getX(), p.getY(), size.getX(), size.getY());
        return r;
    }

    @Override
    public boolean isInitialized() {
        return this._displayImage != null;
    }

    @Override
    public void setImmediateMode(boolean b) {
        this._immediateMode = b;
    }

    @Override
    public boolean isImmediateMode() {
        return this._immediateMode;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("DivaGraphicsImageDisplay");
        DivaGraphicsImageDisplay display = new DivaGraphicsImageDisplay();
        if (args.length > 0) {
            try {
                display.setImage(JAI.create("fileload", args[0]));
            }
            catch (Exception e) {
                System.out.println("error: " + e.toString());
                System.exit(1);
            }
        }
        frame.getContentPane().add((Component)display, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

