/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics.gui;

import diva.canvas.AbstractFigure;
import diva.canvas.Figure;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.image.fits.codec.FITSImage;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageLabel;
import jsky.image.graphics.RoiFigure;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.TclUtil;
import jsky.util.gui.DialogUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;

public class FITSGraphics {
    protected DivaMainImageDisplay imageDisplay;
    protected DivaImageGraphics graphics;
    protected CanvasDraw canvasDraw;
    protected static final int[] PATTERNS = new int[]{10, 9, 8, 6, 4, 2, 1, 0, 9, 8, 7, 6, 5, 4, 3, 1};

    public FITSGraphics(DivaMainImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.graphics = (DivaImageGraphics)imageDisplay.getCanvasGraphics();
        this.canvasDraw = imageDisplay.getCanvasDraw();
    }

    public void saveGraphicsWithImage(String extName) throws FitsException {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage == null) {
            DialogUtil.error("Graphics can only be saved in a FITS image");
            return;
        }
        List<Figure> figureList = this.canvasDraw.getFigureList();
        int n = figureList.size();
        ArrayList<String> typeList = new ArrayList<String>(n);
        ArrayList<String> coordList = new ArrayList<String>(n);
        ArrayList<String> configList = new ArrayList<String>(n);
        ListIterator<Figure> it = figureList.listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            block6: {
                AbstractFigure fig;
                CanvasFigure cfig = (CanvasFigure)it.next();
                if (cfig instanceof ImageFigure) {
                    fig = (ImageFigure)cfig;
                    Shape shape = ((BasicFigure)fig).getShape();
                    Paint fill = ((BasicFigure)fig).getFillPaint();
                    Paint outline = ((BasicFigure)fig).getStrokePaint();
                    float lineWidth = ((BasicFigure)fig).getLineWidth();
                    Composite composite = ((BasicFigure)fig).getComposite();
                    try {
                        String type = this.getType(shape);
                        String coords = this.getCoords(shape);
                        String config = this.getConfig(fill, outline, (int)lineWidth, composite);
                        typeList.add(type);
                        coordList.add(coords);
                        configList.add(config);
                        break block6;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (cfig instanceof ImageLabel) {
                    fig = (ImageLabel)cfig;
                    Font font = ((LabelFigure)fig).getFont();
                    String text = ((LabelFigure)fig).getString();
                    Paint fill = ((LabelFigure)fig).getFillPaint();
                    typeList.add("text");
                    coordList.add(this.getCoords((Point2D.Double)((ImageLabel)fig).getAnchorPoint()));
                    configList.add(this.getConfig(text, font, fill));
                }
            }
            ++i;
        }
        Fits fits = fitsImage.getFits();
        this._deleteBinaryTable(fits, extName);
        BinaryTable table = new BinaryTable();
        FitsFactory.setUseAsciiTables(false);
        table.addColumn(typeList.toArray(new String[typeList.size()]));
        table.addColumn(coordList.toArray(new String[coordList.size()]));
        table.addColumn(configList.toArray(new String[configList.size()]));
        BinaryTableHDU hdu = (BinaryTableHDU)Fits.makeHDU(table);
        hdu.getHeader().addValue("EXTNAME", extName, "Contains saved JSkyCat graphics");
        hdu.setColumnName(0, "type", null);
        hdu.setColumnName(1, "coords", null);
        hdu.setColumnName(2, "config", null);
        this.deleteHDU(extName);
        fits.addHDU(hdu);
        this.imageDisplay.checkExtensions(true);
    }

    private void _deleteBinaryTable(Fits fits, String extName) {
        int n = fits.getNumberOfHDUs();
        for (int i = 0; i < n; ++i) {
            try {
                BasicHDU hdu = fits.getHDU(i);
                if (!(hdu instanceof BinaryTableHDU) || !extName.equals(hdu.getHeader().getStringValue("EXTNAME"))) continue;
                fits.deleteHDU(i);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadGraphicsFromImage(String extName) {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage == null) {
            return;
        }
        int n = fitsImage.getNumHDUs();
        if (n <= 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Header header;
            String name;
            BasicHDU hdu = fitsImage.getHDU(i);
            if (!(hdu instanceof TableHDU) || (name = (header = hdu.getHeader()).getStringValue("EXTNAME")) == null || !name.equals(extName)) continue;
            try {
                this.loadGraphicsFromImage((TableHDU)hdu);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
            return;
        }
    }

    public void loadGraphicsFromImage(TableHDU hdu) throws FitsException {
        int nrows = hdu.getNRows();
        int ncols = hdu.getNCols();
        if (nrows <= 0) {
            return;
        }
        if (ncols < 3) {
            return;
        }
        for (int rowNum = 0; rowNum < nrows; ++rowNum) {
            Object[] row = hdu.getRow(rowNum);
            String type = (String)row[0];
            double[] c = this.getCoords(TclUtil.splitList((String)row[1]));
            String[] config = TclUtil.splitList((String)row[2]);
            Shape shape = null;
            Color fill = null;
            Color outline = Color.white;
            float lineWidth = 1.0f;
            Composite composite = null;
            Font font = CanvasDraw.FONTS[3];
            String text = null;
            SelectionInteractor interactor = this.graphics.getRoiSelectionInteractor();
            for (String aConfig : config) {
                String[] optArg = TclUtil.splitList(aConfig);
                if (optArg.length != 2) continue;
                if (optArg[0].equals("-fill")) {
                    fill = this.getColor(optArg[1]);
                    continue;
                }
                if (optArg[0].equals("-outline")) {
                    outline = this.getColor(optArg[1]);
                    continue;
                }
                if (optArg[0].equals("-width")) {
                    lineWidth = Float.parseFloat(optArg[1]);
                    continue;
                }
                if (optArg[0].equals("-font")) {
                    font = this.getFont(optArg[1]);
                    continue;
                }
                if (optArg[0].equals("-text")) {
                    text = optArg[1];
                    continue;
                }
                if (optArg[0].equals("-stipple")) {
                    composite = this.getStipple(optArg[1]);
                    continue;
                }
                if (!optArg[0].equals("-composite")) continue;
                composite = this.getComposite(optArg[1]);
            }
            if ("rectangle".equals(type)) {
                shape = this.getRectangle(c);
            } else if ("oval".equals(type)) {
                shape = this.getEllipse(c);
            } else if (type.equals("line")) {
                if (outline == null) {
                    outline = fill;
                }
                fill = null;
                shape = this.getPolyline(c);
                if (((Polyline2D)shape).getVertexCount() == 2) {
                    interactor = this.graphics.getLineInteractor();
                }
            } else if ("polygon".equals(type)) {
                shape = this.getPolygon(c);
            } else if ("text".equals(type) && text != null) {
                c = this.imageToScreenCoords(c);
                Point2D.Double pos = new Point2D.Double(c[0], c[1]);
                ImageLabel fig = new ImageLabel(text, pos, fill, font, this.graphics.getSelectionInteractor());
                this.canvasDraw.addFigure(fig);
            } else if ("path".equals(type)) {
                shape = this.getPath(c);
            }
            if (shape == null) continue;
            RoiFigure fig = new RoiFigure(shape, fill, outline, lineWidth, interactor);
            if (composite != null) {
                fig.setComposite((AlphaComposite)composite);
            }
            this.canvasDraw.addFigure(fig);
        }
    }

    protected Rectangle2D.Double getRectangle(double[] coords) {
        double[] c = this.imageToScreenCoords(coords);
        return new Rectangle2D.Double(c[0], c[1], c[2] - c[0], c[3] - c[1]);
    }

    protected Ellipse2D.Double getEllipse(double[] coords) {
        double[] c = this.imageToScreenCoords(coords);
        return new Ellipse2D.Double(c[0], c[1], c[2] - c[0], c[3] - c[1]);
    }

    protected Polyline2D.Double getPolyline(double[] coords) {
        double[] c = this.imageToScreenCoords(coords);
        if (c.length == 4) {
            return new Polyline2D.Double(c[0], c[1], c[2], c[3]);
        }
        if (c.length > 4) {
            Polyline2D.Double p = new Polyline2D.Double(c.length);
            p.moveTo(c[0], c[1]);
            for (int i = 2; i < c.length; i += 2) {
                p.lineTo(c[i], c[i + 1]);
            }
            return p;
        }
        return null;
    }

    protected Polygon2D.Double getPolygon(double[] coords) {
        double[] c = this.imageToScreenCoords(coords);
        Polygon2D.Double p = new Polygon2D.Double(c.length);
        p.moveTo(c[0], c[1]);
        for (int i = 2; i < c.length; i += 2) {
            p.lineTo(c[i], c[i + 1]);
        }
        return p;
    }

    protected Path2D.Double getPath(double[] coords) {
        Path2D.Double p = new Path2D.Double();
        for (int i = 0; i < coords.length; ++i) {
            double[] c;
            int subPathType = (int)coords[i];
            if (subPathType == 0) {
                c = this.imageToScreenCoords(coords, i + 1, 2);
                p.moveTo(c[0], c[1]);
                i += 2;
                continue;
            }
            if (subPathType == 1) {
                c = this.imageToScreenCoords(coords, i + 1, 2);
                p.lineTo(c[0], c[1]);
                i += 2;
                continue;
            }
            if (subPathType == 2) {
                c = this.imageToScreenCoords(coords, i + 1, 4);
                p.quadTo(c[0], c[1], c[2], c[3]);
                i += 4;
                continue;
            }
            if (subPathType == 3) {
                c = this.imageToScreenCoords(coords, i + 1, 6);
                p.curveTo(c[0], c[1], c[2], c[3], c[4], c[5]);
                i += 6;
                continue;
            }
            if (subPathType != 4) continue;
            p.closePath();
        }
        return p;
    }

    public void deleteHDU(String extName) {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        int n = fitsImage.getNumHDUs();
        for (int i = 0; i < n; ++i) {
            Header header;
            String name;
            BasicHDU hdu = fitsImage.getHDU(i);
            if (!(hdu instanceof TableHDU) || (name = (header = hdu.getHeader()).getStringValue("EXTNAME")) == null || !name.equals(extName)) continue;
            try {
                fitsImage.getFits().deleteHDU(i);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
            return;
        }
    }

    protected double[] getCoords(String[] coords) {
        double[] c = new double[coords.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = Double.parseDouble(coords[i]);
        }
        return c;
    }

    protected double[] imageToScreenCoords(double[] coords) {
        return this.imageToScreenCoords(coords, 0, coords.length);
    }

    protected double[] imageToScreenCoords(double[] coords, int offset, int length) {
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        double[] c = new double[length];
        Point2D.Double p = new Point2D.Double();
        for (int i = 0; i < length; i += 2) {
            p.x = coords[i + offset];
            p.y = coords[i + offset + 1];
            coordinateConverter.imageToScreenCoords(p, false);
            c[i] = p.x;
            c[i + 1] = p.y;
        }
        return c;
    }

    protected Color getColor(String s) {
        int i;
        String[] ar = CanvasDraw.COLOR_NAMES;
        int n = ar.length - 1;
        for (i = 0; i < n; ++i) {
            if (!ar[i].equals(s)) continue;
            return CanvasDraw.COLORS[i];
        }
        if (s.startsWith("grey")) {
            try {
                i = Integer.parseInt(s.substring(4));
                if (i > 50) {
                    return Color.lightGray;
                }
                return Color.darkGray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Color.white;
    }

    protected String getColorName(Color c) {
        Color[] ar = CanvasDraw.COLORS;
        int n = ar.length - 1;
        for (int i = 0; i < n; ++i) {
            if (ar[i] != c) continue;
            return CanvasDraw.COLOR_NAMES[i];
        }
        return "white";
    }

    protected Font getFont(String s) {
        return Font.decode(s);
    }

    protected Composite getStipple(String s) {
        if (s.startsWith("pat")) {
            try {
                int i = Integer.parseInt(s.substring(3));
                return CanvasDraw.COMPOSITES[PATTERNS[i]];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Composite getComposite(String s) {
        if (s.endsWith("%")) {
            for (int i = 0; i < CanvasDraw.COMPOSITE_NAMES.length; ++i) {
                if (!s.equals(CanvasDraw.COMPOSITE_NAMES[i])) continue;
                return CanvasDraw.COMPOSITES[i];
            }
        }
        return null;
    }

    protected String getCompositeName(Composite composite) {
        Composite[] ar = CanvasDraw.COMPOSITES;
        int n = ar.length;
        for (int i = 0; i < n; ++i) {
            if (ar[i] != composite) continue;
            return CanvasDraw.COMPOSITE_NAMES[i];
        }
        return CanvasDraw.COMPOSITE_NAMES[0];
    }

    protected String getType(Shape shape) {
        if (shape instanceof Rectangle2D) {
            return "rectangle";
        }
        if (shape instanceof Polyline2D) {
            return "line";
        }
        if (shape instanceof Ellipse2D) {
            return "oval";
        }
        if (shape instanceof Polygon2D) {
            return "polygon";
        }
        if (shape instanceof Path2D) {
            return "path";
        }
        throw new RuntimeException("Unsupported shape for saved graphics: " + shape);
    }

    protected String getCoords(Shape shape) {
        double[] coords = null;
        if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            coords = new double[]{r.getX(), r.getY(), coords[0] + r.getWidth(), coords[1] + r.getHeight()};
            return this.convertCoords(coords, coords.length);
        }
        if (shape instanceof Polyline2D) {
            Polyline2D p = (Polyline2D)shape;
            int n = p.getVertexCount();
            coords = new double[n * 2];
            for (int i = 0; i < n; ++i) {
                coords[i * 2] = p.getX(i);
                coords[i * 2 + 1] = p.getY(i);
            }
            return this.convertCoords(coords, coords.length);
        }
        if (shape instanceof Polygon2D) {
            Polygon2D p = (Polygon2D)shape;
            int n = p.getVertexCount();
            coords = new double[n * 2];
            for (int i = 0; i < n; ++i) {
                coords[i * 2] = p.getX(i);
                coords[i * 2 + 1] = p.getY(i);
            }
            return this.convertCoords(coords, coords.length);
        }
        if (shape instanceof Path2D) {
            Path2D p = (Path2D)shape;
            StringBuffer buf = new StringBuffer();
            coords = new double[6];
            PathIterator pathIter = p.getPathIterator(null);
            while (!pathIter.isDone()) {
                int subPathType = pathIter.currentSegment(coords);
                buf.append(subPathType).append(" ");
                if (subPathType == 0 || subPathType == 1) {
                    buf.append(this.convertCoords(coords, 2)).append(" ");
                } else if (subPathType == 2) {
                    buf.append(this.convertCoords(coords, 4)).append(" ");
                } else if (subPathType == 3) {
                    buf.append(this.convertCoords(coords, 6)).append(" ");
                }
                pathIter.next();
            }
            return buf.toString();
        }
        throw new RuntimeException("Unsupported shape for saved graphics: " + shape);
    }

    protected String convertCoords(double[] coords, int length) {
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double();
        for (int i = 0; i < length; i += 2) {
            p.x = coords[i];
            p.y = coords[i + 1];
            coordinateConverter.screenToImageCoords(p, false);
            coords[i] = p.x;
            coords[i + 1] = p.y;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append(Double.toString(coords[i])).append(' ');
        }
        return buf.toString();
    }

    protected String getCoords(Point2D.Double p) {
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        coordinateConverter.screenToImageCoords(p, false);
        return Double.toString(p.getX()) + " " + Double.toString(p.getY());
    }

    protected String getConfig(Paint fill, Paint outline, int lineWidth, Composite composite) {
        StringBuffer buf = new StringBuffer();
        if (fill != null) {
            buf.append("{-fill ");
            buf.append(this.getColorName((Color)fill));
            buf.append("} ");
        }
        if (outline != null) {
            buf.append("{-outline ");
            buf.append(this.getColorName((Color)outline));
            buf.append("} ");
        }
        if (lineWidth != 1) {
            buf.append("{-width ");
            buf.append(Integer.toString(lineWidth));
            buf.append("} ");
        }
        if (composite != null) {
            buf.append("{-composite ");
            buf.append(this.getCompositeName(composite));
            buf.append("} ");
        }
        return buf.toString();
    }

    protected String getConfig(String text, Font font, Paint fill) {
        StringBuffer buf = new StringBuffer();
        if (text != null) {
            buf.append("{-text {");
            buf.append(text);
            buf.append("}} ");
        }
        if (font != null) {
            buf.append("{-font {");
            String style = font.isItalic() ? "italic" : (font.isBold() ? "bold" : "plain");
            buf.append(font.getFontName()).append("-").append(style).append("-").append(font.getSize());
            buf.append("}} ");
        }
        if (fill != null) {
            buf.append("{-fill ");
            buf.append(this.getColorName((Color)fill));
            buf.append("} ");
        }
        return buf.toString();
    }
}

