/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.interactor.Interactor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.RectangleGeometry;
import jsky.image.graphics.RotatableCanvasFigure;

public class RoiFigure
extends ImageFigure
implements RotatableCanvasFigure {
    protected static final Color DEFAULT_FILL = null;
    protected static final float DEFAULT_LINE_WIDTH = 2.0f;
    protected static final Color DEFAULT_LINE_COLOR = Color.white;
    private RectangleGeometry _geometry;
    private boolean _resizable = true;

    public RoiFigure(Shape shape) {
        super(shape, DEFAULT_FILL, DEFAULT_LINE_COLOR, 2.0f, null);
    }

    public RoiFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        super(shape, fill, outline, lineWidth, interactor);
        this.updateGeometry();
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this._geometry.translate(dx, dy);
        this.repaint();
    }

    @Override
    public void transform(AffineTransform at) {
        super.transform(at);
        this._geometry.transform(at);
        this.repaint();
    }

    @Override
    public RectangleGeometry getGeometry() {
        return this._geometry;
    }

    public void setGeometry(RectangleGeometry geometry) {
        this._geometry = geometry;
    }

    public void updateGeometry() {
        this.setGeometry(new RectangleGeometry(this, this.getShape()));
    }

    @Override
    public boolean isResizable() {
        return this._resizable;
    }

    @Override
    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode();
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.setInteractor(null);
            this.repaint();
        }
    }
}

