/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicFigure;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class ImageFigure
extends BasicFigure
implements CanvasFigure {
    private Object _clientData;
    private CanvasFigureListenerManager _listenerManager = new CanvasFigureListenerManager(this);
    private List<CanvasFigure> _slaves;
    private boolean _persistent;

    public ImageFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        super(shape, fill, lineWidth);
        this.setInteractor(interactor);
        this.setStrokePaint(outline);
    }

    @Override
    public void setClientData(Object o) {
        this._clientData = o;
    }

    @Override
    public Object getClientData() {
        return this._clientData;
    }

    @Override
    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    @Override
    public boolean hit(Rectangle2D r) {
        return this.getShape().getBounds().intersects(r);
    }

    @Override
    public void setVisible(boolean flag) {
        SelectionModel model;
        Interactor interactor;
        super.setVisible(flag);
        if (!flag && (interactor = this.getInteractor()) instanceof SelectionInteractor && (model = ((SelectionInteractor)interactor).getSelectionModel()).containsSelection(this)) {
            model.removeSelection(this);
        }
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    @Override
    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.addCanvasFigureListener(listener);
    }

    @Override
    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.removeCanvasFigureListener(listener);
    }

    @Override
    public void fireCanvasFigureEvent(int eventType) {
        this._listenerManager.fireCanvasFigureEvent(eventType);
    }

    @Override
    public void addSlave(CanvasFigure fig) {
        if (this._slaves == null) {
            this._slaves = new LinkedList<CanvasFigure>();
        }
        this._slaves.add(fig);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        if (this._slaves != null) {
            ListIterator<CanvasFigure> it = this._slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = it.next();
                fig.translate(x, y);
            }
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        g.setComposite(AlphaComposite.Src);
        super.paint(g);
    }
}

