/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import javax.media.jai.Histogram;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import jsky.image.operator.ImageOps;

public class ImageHistogram {
    private Histogram _histogram;
    private PlanarImage _im;
    private int _size;
    private double _lowCut;
    private double _highCut;
    private ROI _roi;
    private int _xPeriod;
    private int _yPeriod;

    public Histogram getHistogram(PlanarImage im, int size, double lowCut, double highCut, ROI roi, int xPeriod, int yPeriod) {
        if (this._histogram != null && im == this._im && size == this._size && lowCut == this._lowCut && highCut == this._highCut && roi.equals(this._roi) && xPeriod == this._xPeriod && yPeriod == this._yPeriod) {
            return this._histogram;
        }
        this._im = im;
        this._size = size;
        this._lowCut = lowCut;
        this._highCut = highCut;
        this._roi = roi;
        this._xPeriod = xPeriod;
        this._yPeriod = yPeriod;
        int numBands = im.getSampleModel().getNumBands();
        int[] numBins = new int[numBands];
        double[] lowValue = new double[numBands];
        double[] highValue = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            numBins[i] = size;
            lowValue[i] = lowCut;
            highValue[i] = highCut;
        }
        this._histogram = ImageOps.histogram(im, roi, xPeriod, yPeriod, numBins, lowValue, highValue);
        return this._histogram;
    }
}

